@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property h265PackagingType
 * @property nameModifier String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs(
    public val h265PackagingType: Output<String>? = null,
    public val nameModifier: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs.builder()
            .h265PackagingType(h265PackagingType?.applyValue({ args0 -> args0 }))
            .nameModifier(nameModifier?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgsBuilder
internal constructor() {
    private var h265PackagingType: Output<String>? = null

    private var nameModifier: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("ftbmfgnqurgohaik")
    public suspend fun h265PackagingType(`value`: Output<String>) {
        this.h265PackagingType = value
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("htnslpxkkjildftp")
    public suspend fun nameModifier(`value`: Output<String>) {
        this.nameModifier = value
    }

    /**
     * @param value
     */
    @JvmName("txtglkyyvbxrloxs")
    public suspend fun h265PackagingType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.h265PackagingType = mapped
    }

    /**
     * @param value String concatenated to the end of the destination filename. Required for multiple outputs of the same type.
     */
    @JvmName("nxsdllnrgvttqhwu")
    public suspend fun nameModifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameModifier = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsMsSmoothOutputSettingsArgs(
            h265PackagingType = h265PackagingType,
            nameModifier = nameModifier,
        )
}
