@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property absentInputAudioBehavior
 * @property arib
 * @property aribCaptionsPid
 * @property aribCaptionsPidControl
 * @property audioBufferModel
 * @property audioFramesPerPes
 * @property audioPids
 * @property audioStreamType
 * @property bitrate
 * @property bufferModel
 * @property ccDescriptor
 * @property dvbNitSettings
 * @property dvbSdtSettings
 * @property dvbSubPids
 * @property dvbTdtSettings
 * @property dvbTeletextPid
 * @property ebif
 * @property ebpAudioInterval
 * @property ebpLookaheadMs
 * @property ebpPlacement
 * @property ecmPid
 * @property esRateInPes
 * @property etvPlatformPid
 * @property etvSignalPid
 * @property fragmentTime
 * @property klv
 * @property klvDataPids
 * @property nielsenId3Behavior
 * @property nullPacketBitrate
 * @property patInterval
 * @property pcrControl
 * @property pcrPeriod
 * @property pcrPid
 * @property pmtInterval
 * @property pmtPid
 * @property programNum
 * @property rateMode
 * @property scte27Pids
 * @property scte35Control
 * @property scte35Pid PID from which to read SCTE-35 messages.
 * @property segmentationMarkers
 * @property segmentationStyle
 * @property segmentationTime
 * @property timedMetadataBehavior
 * @property timedMetadataPid
 * @property transportStreamId
 * @property videoPid
 */
public data class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs(
    public val absentInputAudioBehavior: Output<String>? = null,
    public val arib: Output<String>? = null,
    public val aribCaptionsPid: Output<String>? = null,
    public val aribCaptionsPidControl: Output<String>? = null,
    public val audioBufferModel: Output<String>? = null,
    public val audioFramesPerPes: Output<Int>? = null,
    public val audioPids: Output<String>? = null,
    public val audioStreamType: Output<String>? = null,
    public val bitrate: Output<Int>? = null,
    public val bufferModel: Output<String>? = null,
    public val ccDescriptor: Output<String>? = null,
    public val dvbNitSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>? =
        null,
    public val dvbSdtSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>? =
        null,
    public val dvbSubPids: Output<String>? = null,
    public val dvbTdtSettings: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>? =
        null,
    public val dvbTeletextPid: Output<String>? = null,
    public val ebif: Output<String>? = null,
    public val ebpAudioInterval: Output<String>? = null,
    public val ebpLookaheadMs: Output<Int>? = null,
    public val ebpPlacement: Output<String>? = null,
    public val ecmPid: Output<String>? = null,
    public val esRateInPes: Output<String>? = null,
    public val etvPlatformPid: Output<String>? = null,
    public val etvSignalPid: Output<String>? = null,
    public val fragmentTime: Output<Double>? = null,
    public val klv: Output<String>? = null,
    public val klvDataPids: Output<String>? = null,
    public val nielsenId3Behavior: Output<String>? = null,
    public val nullPacketBitrate: Output<Double>? = null,
    public val patInterval: Output<Int>? = null,
    public val pcrControl: Output<String>? = null,
    public val pcrPeriod: Output<Int>? = null,
    public val pcrPid: Output<String>? = null,
    public val pmtInterval: Output<Int>? = null,
    public val pmtPid: Output<String>? = null,
    public val programNum: Output<Int>? = null,
    public val rateMode: Output<String>? = null,
    public val scte27Pids: Output<String>? = null,
    public val scte35Control: Output<String>? = null,
    public val scte35Pid: Output<String>? = null,
    public val segmentationMarkers: Output<String>? = null,
    public val segmentationStyle: Output<String>? = null,
    public val segmentationTime: Output<Double>? = null,
    public val timedMetadataBehavior: Output<String>? = null,
    public val timedMetadataPid: Output<String>? = null,
    public val transportStreamId: Output<Int>? = null,
    public val videoPid: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs.builder()
            .absentInputAudioBehavior(absentInputAudioBehavior?.applyValue({ args0 -> args0 }))
            .arib(arib?.applyValue({ args0 -> args0 }))
            .aribCaptionsPid(aribCaptionsPid?.applyValue({ args0 -> args0 }))
            .aribCaptionsPidControl(aribCaptionsPidControl?.applyValue({ args0 -> args0 }))
            .audioBufferModel(audioBufferModel?.applyValue({ args0 -> args0 }))
            .audioFramesPerPes(audioFramesPerPes?.applyValue({ args0 -> args0 }))
            .audioPids(audioPids?.applyValue({ args0 -> args0 }))
            .audioStreamType(audioStreamType?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bufferModel(bufferModel?.applyValue({ args0 -> args0 }))
            .ccDescriptor(ccDescriptor?.applyValue({ args0 -> args0 }))
            .dvbNitSettings(dvbNitSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbSdtSettings(dvbSdtSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbSubPids(dvbSubPids?.applyValue({ args0 -> args0 }))
            .dvbTdtSettings(dvbTdtSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dvbTeletextPid(dvbTeletextPid?.applyValue({ args0 -> args0 }))
            .ebif(ebif?.applyValue({ args0 -> args0 }))
            .ebpAudioInterval(ebpAudioInterval?.applyValue({ args0 -> args0 }))
            .ebpLookaheadMs(ebpLookaheadMs?.applyValue({ args0 -> args0 }))
            .ebpPlacement(ebpPlacement?.applyValue({ args0 -> args0 }))
            .ecmPid(ecmPid?.applyValue({ args0 -> args0 }))
            .esRateInPes(esRateInPes?.applyValue({ args0 -> args0 }))
            .etvPlatformPid(etvPlatformPid?.applyValue({ args0 -> args0 }))
            .etvSignalPid(etvSignalPid?.applyValue({ args0 -> args0 }))
            .fragmentTime(fragmentTime?.applyValue({ args0 -> args0 }))
            .klv(klv?.applyValue({ args0 -> args0 }))
            .klvDataPids(klvDataPids?.applyValue({ args0 -> args0 }))
            .nielsenId3Behavior(nielsenId3Behavior?.applyValue({ args0 -> args0 }))
            .nullPacketBitrate(nullPacketBitrate?.applyValue({ args0 -> args0 }))
            .patInterval(patInterval?.applyValue({ args0 -> args0 }))
            .pcrControl(pcrControl?.applyValue({ args0 -> args0 }))
            .pcrPeriod(pcrPeriod?.applyValue({ args0 -> args0 }))
            .pcrPid(pcrPid?.applyValue({ args0 -> args0 }))
            .pmtInterval(pmtInterval?.applyValue({ args0 -> args0 }))
            .pmtPid(pmtPid?.applyValue({ args0 -> args0 }))
            .programNum(programNum?.applyValue({ args0 -> args0 }))
            .rateMode(rateMode?.applyValue({ args0 -> args0 }))
            .scte27Pids(scte27Pids?.applyValue({ args0 -> args0 }))
            .scte35Control(scte35Control?.applyValue({ args0 -> args0 }))
            .scte35Pid(scte35Pid?.applyValue({ args0 -> args0 }))
            .segmentationMarkers(segmentationMarkers?.applyValue({ args0 -> args0 }))
            .segmentationStyle(segmentationStyle?.applyValue({ args0 -> args0 }))
            .segmentationTime(segmentationTime?.applyValue({ args0 -> args0 }))
            .timedMetadataBehavior(timedMetadataBehavior?.applyValue({ args0 -> args0 }))
            .timedMetadataPid(timedMetadataPid?.applyValue({ args0 -> args0 }))
            .transportStreamId(transportStreamId?.applyValue({ args0 -> args0 }))
            .videoPid(videoPid?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgsBuilder
internal constructor() {
    private var absentInputAudioBehavior: Output<String>? = null

    private var arib: Output<String>? = null

    private var aribCaptionsPid: Output<String>? = null

    private var aribCaptionsPidControl: Output<String>? = null

    private var audioBufferModel: Output<String>? = null

    private var audioFramesPerPes: Output<Int>? = null

    private var audioPids: Output<String>? = null

    private var audioStreamType: Output<String>? = null

    private var bitrate: Output<Int>? = null

    private var bufferModel: Output<String>? = null

    private var ccDescriptor: Output<String>? = null

    private var dvbNitSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>? =
        null

    private var dvbSdtSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>? =
        null

    private var dvbSubPids: Output<String>? = null

    private var dvbTdtSettings:
        Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>? =
        null

    private var dvbTeletextPid: Output<String>? = null

    private var ebif: Output<String>? = null

    private var ebpAudioInterval: Output<String>? = null

    private var ebpLookaheadMs: Output<Int>? = null

    private var ebpPlacement: Output<String>? = null

    private var ecmPid: Output<String>? = null

    private var esRateInPes: Output<String>? = null

    private var etvPlatformPid: Output<String>? = null

    private var etvSignalPid: Output<String>? = null

    private var fragmentTime: Output<Double>? = null

    private var klv: Output<String>? = null

    private var klvDataPids: Output<String>? = null

    private var nielsenId3Behavior: Output<String>? = null

    private var nullPacketBitrate: Output<Double>? = null

    private var patInterval: Output<Int>? = null

    private var pcrControl: Output<String>? = null

    private var pcrPeriod: Output<Int>? = null

    private var pcrPid: Output<String>? = null

    private var pmtInterval: Output<Int>? = null

    private var pmtPid: Output<String>? = null

    private var programNum: Output<Int>? = null

    private var rateMode: Output<String>? = null

    private var scte27Pids: Output<String>? = null

    private var scte35Control: Output<String>? = null

    private var scte35Pid: Output<String>? = null

    private var segmentationMarkers: Output<String>? = null

    private var segmentationStyle: Output<String>? = null

    private var segmentationTime: Output<Double>? = null

    private var timedMetadataBehavior: Output<String>? = null

    private var timedMetadataPid: Output<String>? = null

    private var transportStreamId: Output<Int>? = null

    private var videoPid: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("yimynhndxihhuntn")
    public suspend fun absentInputAudioBehavior(`value`: Output<String>) {
        this.absentInputAudioBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("uqcomntmbuliwrsi")
    public suspend fun arib(`value`: Output<String>) {
        this.arib = value
    }

    /**
     * @param value
     */
    @JvmName("kviehqjunegsqmii")
    public suspend fun aribCaptionsPid(`value`: Output<String>) {
        this.aribCaptionsPid = value
    }

    /**
     * @param value
     */
    @JvmName("rmssphcqduvttvde")
    public suspend fun aribCaptionsPidControl(`value`: Output<String>) {
        this.aribCaptionsPidControl = value
    }

    /**
     * @param value
     */
    @JvmName("mbamxqprqomshauh")
    public suspend fun audioBufferModel(`value`: Output<String>) {
        this.audioBufferModel = value
    }

    /**
     * @param value
     */
    @JvmName("bbfmucoianfjxlyn")
    public suspend fun audioFramesPerPes(`value`: Output<Int>) {
        this.audioFramesPerPes = value
    }

    /**
     * @param value
     */
    @JvmName("mguclquiwskdvqjl")
    public suspend fun audioPids(`value`: Output<String>) {
        this.audioPids = value
    }

    /**
     * @param value
     */
    @JvmName("knpiuyjvwtwisqip")
    public suspend fun audioStreamType(`value`: Output<String>) {
        this.audioStreamType = value
    }

    /**
     * @param value
     */
    @JvmName("agarwajhchnpxkoh")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value
     */
    @JvmName("oncfyxrfiuyveigd")
    public suspend fun bufferModel(`value`: Output<String>) {
        this.bufferModel = value
    }

    /**
     * @param value
     */
    @JvmName("wpnmydahvgflibxa")
    public suspend fun ccDescriptor(`value`: Output<String>) {
        this.ccDescriptor = value
    }

    /**
     * @param value
     */
    @JvmName("vduwgptqrprceyuc")
    public suspend fun dvbNitSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs>) {
        this.dvbNitSettings = value
    }

    /**
     * @param value
     */
    @JvmName("pxbqwvomqfqovubl")
    public suspend fun dvbSdtSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs>) {
        this.dvbSdtSettings = value
    }

    /**
     * @param value
     */
    @JvmName("possksmicvyeiirl")
    public suspend fun dvbSubPids(`value`: Output<String>) {
        this.dvbSubPids = value
    }

    /**
     * @param value
     */
    @JvmName("tlfhcovctemvtkkh")
    public suspend fun dvbTdtSettings(`value`: Output<ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs>) {
        this.dvbTdtSettings = value
    }

    /**
     * @param value
     */
    @JvmName("kfugaltxmaygdrsi")
    public suspend fun dvbTeletextPid(`value`: Output<String>) {
        this.dvbTeletextPid = value
    }

    /**
     * @param value
     */
    @JvmName("ufoyqvpojyxutfri")
    public suspend fun ebif(`value`: Output<String>) {
        this.ebif = value
    }

    /**
     * @param value
     */
    @JvmName("xbtodhxsesknqgok")
    public suspend fun ebpAudioInterval(`value`: Output<String>) {
        this.ebpAudioInterval = value
    }

    /**
     * @param value
     */
    @JvmName("sptgbbummmbmtxwq")
    public suspend fun ebpLookaheadMs(`value`: Output<Int>) {
        this.ebpLookaheadMs = value
    }

    /**
     * @param value
     */
    @JvmName("uauvymvxyalilipp")
    public suspend fun ebpPlacement(`value`: Output<String>) {
        this.ebpPlacement = value
    }

    /**
     * @param value
     */
    @JvmName("xtgcrojkurnkxumw")
    public suspend fun ecmPid(`value`: Output<String>) {
        this.ecmPid = value
    }

    /**
     * @param value
     */
    @JvmName("hftsghvoduattxrk")
    public suspend fun esRateInPes(`value`: Output<String>) {
        this.esRateInPes = value
    }

    /**
     * @param value
     */
    @JvmName("skakvhpyoqmewrmf")
    public suspend fun etvPlatformPid(`value`: Output<String>) {
        this.etvPlatformPid = value
    }

    /**
     * @param value
     */
    @JvmName("mpnybssrhqeschhh")
    public suspend fun etvSignalPid(`value`: Output<String>) {
        this.etvSignalPid = value
    }

    /**
     * @param value
     */
    @JvmName("fhjjhoxmhhfphrjf")
    public suspend fun fragmentTime(`value`: Output<Double>) {
        this.fragmentTime = value
    }

    /**
     * @param value
     */
    @JvmName("sxcrthkohfssejih")
    public suspend fun klv(`value`: Output<String>) {
        this.klv = value
    }

    /**
     * @param value
     */
    @JvmName("pyisyuwhiewajcbf")
    public suspend fun klvDataPids(`value`: Output<String>) {
        this.klvDataPids = value
    }

    /**
     * @param value
     */
    @JvmName("jltskxxppiideqgc")
    public suspend fun nielsenId3Behavior(`value`: Output<String>) {
        this.nielsenId3Behavior = value
    }

    /**
     * @param value
     */
    @JvmName("trjtoikykavxsclo")
    public suspend fun nullPacketBitrate(`value`: Output<Double>) {
        this.nullPacketBitrate = value
    }

    /**
     * @param value
     */
    @JvmName("jqftpitsutkphmrj")
    public suspend fun patInterval(`value`: Output<Int>) {
        this.patInterval = value
    }

    /**
     * @param value
     */
    @JvmName("kmlplwpvsuogsyhn")
    public suspend fun pcrControl(`value`: Output<String>) {
        this.pcrControl = value
    }

    /**
     * @param value
     */
    @JvmName("iasgirppgrehqsaj")
    public suspend fun pcrPeriod(`value`: Output<Int>) {
        this.pcrPeriod = value
    }

    /**
     * @param value
     */
    @JvmName("qvfwyncmmgnegqjj")
    public suspend fun pcrPid(`value`: Output<String>) {
        this.pcrPid = value
    }

    /**
     * @param value
     */
    @JvmName("aeissquvhwedtilt")
    public suspend fun pmtInterval(`value`: Output<Int>) {
        this.pmtInterval = value
    }

    /**
     * @param value
     */
    @JvmName("vjtvtsrafevrvfre")
    public suspend fun pmtPid(`value`: Output<String>) {
        this.pmtPid = value
    }

    /**
     * @param value
     */
    @JvmName("ltfxugfmdwkcsgwy")
    public suspend fun programNum(`value`: Output<Int>) {
        this.programNum = value
    }

    /**
     * @param value
     */
    @JvmName("ursoclbhfqdwcrmf")
    public suspend fun rateMode(`value`: Output<String>) {
        this.rateMode = value
    }

    /**
     * @param value
     */
    @JvmName("nllcatxadxqhjttd")
    public suspend fun scte27Pids(`value`: Output<String>) {
        this.scte27Pids = value
    }

    /**
     * @param value
     */
    @JvmName("vvmlxodlcmkgwrbs")
    public suspend fun scte35Control(`value`: Output<String>) {
        this.scte35Control = value
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("istaxmtcyebhodwy")
    public suspend fun scte35Pid(`value`: Output<String>) {
        this.scte35Pid = value
    }

    /**
     * @param value
     */
    @JvmName("nqcopvfeckcdpowq")
    public suspend fun segmentationMarkers(`value`: Output<String>) {
        this.segmentationMarkers = value
    }

    /**
     * @param value
     */
    @JvmName("dglshpcnbgyhnosm")
    public suspend fun segmentationStyle(`value`: Output<String>) {
        this.segmentationStyle = value
    }

    /**
     * @param value
     */
    @JvmName("rxmpspyjyfgclddk")
    public suspend fun segmentationTime(`value`: Output<Double>) {
        this.segmentationTime = value
    }

    /**
     * @param value
     */
    @JvmName("jgbqwkiqpbraqerg")
    public suspend fun timedMetadataBehavior(`value`: Output<String>) {
        this.timedMetadataBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("fpwbduqqehqeliun")
    public suspend fun timedMetadataPid(`value`: Output<String>) {
        this.timedMetadataPid = value
    }

    /**
     * @param value
     */
    @JvmName("urasbavxupjmrcdo")
    public suspend fun transportStreamId(`value`: Output<Int>) {
        this.transportStreamId = value
    }

    /**
     * @param value
     */
    @JvmName("brusywwawrugkodj")
    public suspend fun videoPid(`value`: Output<String>) {
        this.videoPid = value
    }

    /**
     * @param value
     */
    @JvmName("riicxaxfmadxwmnf")
    public suspend fun absentInputAudioBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.absentInputAudioBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjrcoudoxcaxtbil")
    public suspend fun arib(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arib = mapped
    }

    /**
     * @param value
     */
    @JvmName("pkjxwuwmppusvuhx")
    public suspend fun aribCaptionsPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribCaptionsPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("ycowdhxonvdywqfb")
    public suspend fun aribCaptionsPidControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribCaptionsPidControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("qexxvntlojegyghi")
    public suspend fun audioBufferModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioBufferModel = mapped
    }

    /**
     * @param value
     */
    @JvmName("nwrplsdkensgyptr")
    public suspend fun audioFramesPerPes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioFramesPerPes = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjwegtwnjftushqi")
    public suspend fun audioPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("trwhqguuqxymabja")
    public suspend fun audioStreamType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioStreamType = mapped
    }

    /**
     * @param value
     */
    @JvmName("oudgsdsiajncgvgx")
    public suspend fun bitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("ugtijpaxopoveieq")
    public suspend fun bufferModel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferModel = mapped
    }

    /**
     * @param value
     */
    @JvmName("sdhcqobfwglhkrtt")
    public suspend fun ccDescriptor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ccDescriptor = mapped
    }

    /**
     * @param value
     */
    @JvmName("vjlmxdtuuuexllkt")
    public suspend fun dvbNitSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbNitSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gxxefmftdasjbnhl")
    public suspend fun dvbNitSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbNitSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbNitSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("mmugsdgqncbgqcwa")
    public suspend fun dvbSdtSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSdtSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("svgoksjwxtddrsxe")
    public suspend fun dvbSdtSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbSdtSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbSdtSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("eplexsioranduksf")
    public suspend fun dvbSubPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSubPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("ybafrnbgiiliqvty")
    public suspend fun dvbTdtSettings(`value`: ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbTdtSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ilixanbcfymdmswt")
    public suspend fun dvbTdtSettings(argument: suspend ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsDvbTdtSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbTdtSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("baswfmsljpjbjryq")
    public suspend fun dvbTeletextPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbTeletextPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("jgjyyfvwgtkekwir")
    public suspend fun ebif(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebif = mapped
    }

    /**
     * @param value
     */
    @JvmName("jndlrfksmnrkfbto")
    public suspend fun ebpAudioInterval(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpAudioInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("pcefaepypfgryiaq")
    public suspend fun ebpLookaheadMs(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpLookaheadMs = mapped
    }

    /**
     * @param value
     */
    @JvmName("ykutgajwjfwqnjdw")
    public suspend fun ebpPlacement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebpPlacement = mapped
    }

    /**
     * @param value
     */
    @JvmName("mrxgcjsmhrfdoitc")
    public suspend fun ecmPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ecmPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("wfpeqqskbyubthej")
    public suspend fun esRateInPes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.esRateInPes = mapped
    }

    /**
     * @param value
     */
    @JvmName("ueoaewxnllqathfj")
    public suspend fun etvPlatformPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etvPlatformPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("tbkaxhefjbanisao")
    public suspend fun etvSignalPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.etvSignalPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("hbkyrjyceombsqsk")
    public suspend fun fragmentTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fragmentTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("islpjssptwpsocir")
    public suspend fun klv(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.klv = mapped
    }

    /**
     * @param value
     */
    @JvmName("tnqtgbfukdrefsnd")
    public suspend fun klvDataPids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.klvDataPids = mapped
    }

    /**
     * @param value
     */
    @JvmName("mhykwrctdgkeoemx")
    public suspend fun nielsenId3Behavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenId3Behavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("njvdaxoaxhkdxfym")
    public suspend fun nullPacketBitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nullPacketBitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("fmcyjaouwogeflfc")
    public suspend fun patInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.patInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("jmlgpmdyqovfqfyp")
    public suspend fun pcrControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("alisyxqoyvbngpvi")
    public suspend fun pcrPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPeriod = mapped
    }

    /**
     * @param value
     */
    @JvmName("eggpuwqkwnxalgcs")
    public suspend fun pcrPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pcrPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("smajahnhyeeewhyr")
    public suspend fun pmtInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("talofbxnmlhgulhj")
    public suspend fun pmtPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pmtPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("eenndubbekuibdsp")
    public suspend fun programNum(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programNum = mapped
    }

    /**
     * @param value
     */
    @JvmName("gnvvugwmmoilvarc")
    public suspend fun rateMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("rslswcapfymildpo")
    public suspend fun scte27Pids(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte27Pids = mapped
    }

    /**
     * @param value
     */
    @JvmName("inlgwrrypgvylfcn")
    public suspend fun scte35Control(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Control = mapped
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("xkessshsejtjkawg")
    public suspend fun scte35Pid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Pid = mapped
    }

    /**
     * @param value
     */
    @JvmName("vinbsupimouadlmj")
    public suspend fun segmentationMarkers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationMarkers = mapped
    }

    /**
     * @param value
     */
    @JvmName("efdlpdnqdcmpmlqb")
    public suspend fun segmentationStyle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationStyle = mapped
    }

    /**
     * @param value
     */
    @JvmName("wvicemorccnihdnb")
    public suspend fun segmentationTime(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.segmentationTime = mapped
    }

    /**
     * @param value
     */
    @JvmName("mxqowopsrripwmcq")
    public suspend fun timedMetadataBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("gywckggslvvasdxy")
    public suspend fun timedMetadataPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timedMetadataPid = mapped
    }

    /**
     * @param value
     */
    @JvmName("uiwiauhocmkedwtt")
    public suspend fun transportStreamId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportStreamId = mapped
    }

    /**
     * @param value
     */
    @JvmName("kkacifqgkrcpdcra")
    public suspend fun videoPid(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoPid = mapped
    }

    internal fun build(): ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs =
        ChannelEncoderSettingsOutputGroupOutputOutputSettingsUdpOutputSettingsContainerSettingsM2tsSettingsArgs(
            absentInputAudioBehavior = absentInputAudioBehavior,
            arib = arib,
            aribCaptionsPid = aribCaptionsPid,
            aribCaptionsPidControl = aribCaptionsPidControl,
            audioBufferModel = audioBufferModel,
            audioFramesPerPes = audioFramesPerPes,
            audioPids = audioPids,
            audioStreamType = audioStreamType,
            bitrate = bitrate,
            bufferModel = bufferModel,
            ccDescriptor = ccDescriptor,
            dvbNitSettings = dvbNitSettings,
            dvbSdtSettings = dvbSdtSettings,
            dvbSubPids = dvbSubPids,
            dvbTdtSettings = dvbTdtSettings,
            dvbTeletextPid = dvbTeletextPid,
            ebif = ebif,
            ebpAudioInterval = ebpAudioInterval,
            ebpLookaheadMs = ebpLookaheadMs,
            ebpPlacement = ebpPlacement,
            ecmPid = ecmPid,
            esRateInPes = esRateInPes,
            etvPlatformPid = etvPlatformPid,
            etvSignalPid = etvSignalPid,
            fragmentTime = fragmentTime,
            klv = klv,
            klvDataPids = klvDataPids,
            nielsenId3Behavior = nielsenId3Behavior,
            nullPacketBitrate = nullPacketBitrate,
            patInterval = patInterval,
            pcrControl = pcrControl,
            pcrPeriod = pcrPeriod,
            pcrPid = pcrPid,
            pmtInterval = pmtInterval,
            pmtPid = pmtPid,
            programNum = programNum,
            rateMode = rateMode,
            scte27Pids = scte27Pids,
            scte35Control = scte35Control,
            scte35Pid = scte35Pid,
            segmentationMarkers = segmentationMarkers,
            segmentationStyle = segmentationStyle,
            segmentationTime = segmentationTime,
            timedMetadataBehavior = timedMetadataBehavior,
            timedMetadataPid = timedMetadataPid,
            transportStreamId = transportStreamId,
            videoPid = videoPid,
        )
}
