@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codecSettings The video codec settings. See Video Codec Settings for more details.
 * @property height Output video height in pixels.
 * @property name The name of the video description.
 * @property respondToAfd Indicate how to respond to the AFD values that might be in the input video.
 * @property scalingBehavior Behavior on how to scale.
 * @property sharpness Changes the strength of the anti-alias filter used for scaling.
 * @property width Output video width in pixels.
 */
public data class ChannelEncoderSettingsVideoDescriptionArgs(
    public val codecSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs>? = null,
    public val height: Output<Int>? = null,
    public val name: Output<String>,
    public val respondToAfd: Output<String>? = null,
    public val scalingBehavior: Output<String>? = null,
    public val sharpness: Output<Int>? = null,
    public val width: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionArgs = com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionArgs.builder()
        .codecSettings(codecSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .height(height?.applyValue({ args0 -> args0 }))
        .name(name.applyValue({ args0 -> args0 }))
        .respondToAfd(respondToAfd?.applyValue({ args0 -> args0 }))
        .scalingBehavior(scalingBehavior?.applyValue({ args0 -> args0 }))
        .sharpness(sharpness?.applyValue({ args0 -> args0 }))
        .width(width?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsVideoDescriptionArgsBuilder internal constructor() {
    private var codecSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs>? = null

    private var height: Output<Int>? = null

    private var name: Output<String>? = null

    private var respondToAfd: Output<String>? = null

    private var scalingBehavior: Output<String>? = null

    private var sharpness: Output<Int>? = null

    private var width: Output<Int>? = null

    /**
     * @param value The video codec settings. See Video Codec Settings for more details.
     */
    @JvmName("hiauapikdymwyryw")
    public suspend fun codecSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs>) {
        this.codecSettings = value
    }

    /**
     * @param value Output video height in pixels.
     */
    @JvmName("idsampshltsgpqna")
    public suspend fun height(`value`: Output<Int>) {
        this.height = value
    }

    /**
     * @param value The name of the video description.
     */
    @JvmName("xsotinuvkrvcqres")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Indicate how to respond to the AFD values that might be in the input video.
     */
    @JvmName("bhyyftdbgqfgpewe")
    public suspend fun respondToAfd(`value`: Output<String>) {
        this.respondToAfd = value
    }

    /**
     * @param value Behavior on how to scale.
     */
    @JvmName("boncbakmkhtewhlm")
    public suspend fun scalingBehavior(`value`: Output<String>) {
        this.scalingBehavior = value
    }

    /**
     * @param value Changes the strength of the anti-alias filter used for scaling.
     */
    @JvmName("edrfmdfciwukters")
    public suspend fun sharpness(`value`: Output<Int>) {
        this.sharpness = value
    }

    /**
     * @param value Output video width in pixels.
     */
    @JvmName("nykfvysadlvevtqt")
    public suspend fun width(`value`: Output<Int>) {
        this.width = value
    }

    /**
     * @param value The video codec settings. See Video Codec Settings for more details.
     */
    @JvmName("bevmtqjixyyuevjq")
    public suspend fun codecSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codecSettings = mapped
    }

    /**
     * @param argument The video codec settings. See Video Codec Settings for more details.
     */
    @JvmName("abnlsepjpxolnpfj")
    public suspend fun codecSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsVideoDescriptionCodecSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codecSettings = mapped
    }

    /**
     * @param value Output video height in pixels.
     */
    @JvmName("xhqebqdttcgbcjuf")
    public suspend fun height(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.height = mapped
    }

    /**
     * @param value The name of the video description.
     */
    @JvmName("vitemuohmvgbjaok")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Indicate how to respond to the AFD values that might be in the input video.
     */
    @JvmName("xllnilqrgmamwuuk")
    public suspend fun respondToAfd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.respondToAfd = mapped
    }

    /**
     * @param value Behavior on how to scale.
     */
    @JvmName("hhqmfrgysndcwoha")
    public suspend fun scalingBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingBehavior = mapped
    }

    /**
     * @param value Changes the strength of the anti-alias filter used for scaling.
     */
    @JvmName("ntaagavrvobrnwxv")
    public suspend fun sharpness(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sharpness = mapped
    }

    /**
     * @param value Output video width in pixels.
     */
    @JvmName("rojcclavvfnampdm")
    public suspend fun width(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.width = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionArgs =
        ChannelEncoderSettingsVideoDescriptionArgs(
            codecSettings = codecSettings,
            height = height,
            name = name ?: throw PulumiNullFieldException("name"),
            respondToAfd = respondToAfd,
            scalingBehavior = scalingBehavior,
            sharpness = sharpness,
            width = width,
        )
}
