@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property frameCaptureSettings Frame capture settings. See Frame Capture Settings for more details.
 * @property h264Settings H264 settings. See H264 Settings for more details.
 * @property h265Settings
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs(
    public val frameCaptureSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs>? = null,
    public val h264Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs>? = null,
    public val h265Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs.builder()
            .frameCaptureSettings(
                frameCaptureSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .h264Settings(h264Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .h265Settings(h265Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsVideoDescriptionCodecSettingsArgsBuilder internal constructor() {
    private var frameCaptureSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs>? = null

    private var h264Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs>? = null

    private var h265Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs>? = null

    /**
     * @param value Frame capture settings. See Frame Capture Settings for more details.
     */
    @JvmName("rxpthxolrxyjpwgw")
    public suspend fun frameCaptureSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs>) {
        this.frameCaptureSettings = value
    }

    /**
     * @param value H264 settings. See H264 Settings for more details.
     */
    @JvmName("usqmxmyglqlfssdu")
    public suspend fun h264Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs>) {
        this.h264Settings = value
    }

    /**
     * @param value
     */
    @JvmName("cgefwehjpkkgymwi")
    public suspend fun h265Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs>) {
        this.h265Settings = value
    }

    /**
     * @param value Frame capture settings. See Frame Capture Settings for more details.
     */
    @JvmName("xvqjkpafqkuervac")
    public suspend fun frameCaptureSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frameCaptureSettings = mapped
    }

    /**
     * @param argument Frame capture settings. See Frame Capture Settings for more details.
     */
    @JvmName("ddkdiwpflpakssss")
    public suspend fun frameCaptureSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.frameCaptureSettings = mapped
    }

    /**
     * @param value H264 settings. See H264 Settings for more details.
     */
    @JvmName("hafhrwserdfkqkvw")
    public suspend fun h264Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.h264Settings = mapped
    }

    /**
     * @param argument H264 settings. See H264 Settings for more details.
     */
    @JvmName("kmunthrabhhnuccj")
    public suspend fun h264Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.h264Settings = mapped
    }

    /**
     * @param value
     */
    @JvmName("wfpudkfpbttguysc")
    public suspend fun h265Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.h265Settings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rnaqjttuwvsxtkwd")
    public suspend fun h265Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.h265Settings = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsArgs(
            frameCaptureSettings = frameCaptureSettings,
            h264Settings = h264Settings,
            h265Settings = h265Settings,
        )
}
