@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property captureInterval The frequency at which to capture frames for inclusion in the output.
 * @property captureIntervalUnits Unit for the frame capture interval.
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs(
    public val captureInterval: Output<Int>? = null,
    public val captureIntervalUnits: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs.builder()
            .captureInterval(captureInterval?.applyValue({ args0 -> args0 }))
            .captureIntervalUnits(captureIntervalUnits?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgsBuilder
internal constructor() {
    private var captureInterval: Output<Int>? = null

    private var captureIntervalUnits: Output<String>? = null

    /**
     * @param value The frequency at which to capture frames for inclusion in the output.
     */
    @JvmName("oypauhoxdnmrtmia")
    public suspend fun captureInterval(`value`: Output<Int>) {
        this.captureInterval = value
    }

    /**
     * @param value Unit for the frame capture interval.
     */
    @JvmName("fgahxokeqbjnraau")
    public suspend fun captureIntervalUnits(`value`: Output<String>) {
        this.captureIntervalUnits = value
    }

    /**
     * @param value The frequency at which to capture frames for inclusion in the output.
     */
    @JvmName("xknctxfeybnqcskl")
    public suspend fun captureInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captureInterval = mapped
    }

    /**
     * @param value Unit for the frame capture interval.
     */
    @JvmName("oqluihywaehryuxd")
    public suspend fun captureIntervalUnits(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captureIntervalUnits = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs = ChannelEncoderSettingsVideoDescriptionCodecSettingsFrameCaptureSettingsArgs(
        captureInterval = captureInterval,
        captureIntervalUnits = captureIntervalUnits,
    )
}
