@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property adaptiveQuantization Enables or disables adaptive quantization.
 * @property afdSignaling Indicates that AFD values will be written into the output stream.
 * @property alternativeTransferFunction Whether or not EML should insert an Alternative Transfer Function SEI message.
 * @property bitrate Average bitrate in bits/second.
 * @property bufSize Size of buffer in bits.
 * @property colorMetadata Includes color space metadata in the output.
 * @property colorSpaceSettings Define the color metadata for the output. H265 Color Space Settings for more details.
 * @property filterSettings Filters to apply to an encode. See H265 Filter Settings for more details.
 * @property fixedAfd Four bit AFD value to write on all frames of video in the output stream.
 * @property flickerAq
 * @property framerateDenominator Framerate denominator.
 * @property framerateNumerator Framerate numerator.
 * @property gopClosedCadence Frequency of closed GOPs.
 * @property gopSize GOP size in units of either frames of seconds per `gop_size_units`.
 * @property gopSizeUnits Indicates if the `gop_size` is specified in frames or seconds.
 * @property level H265 level.
 * @property lookAheadRateControl Amount of lookahead.
 * @property maxBitrate Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
 * @property minIInterval
 * @property parDenominator Pixel Aspect Ratio denominator.
 * @property parNumerator Pixel Aspect Ratio numerator.
 * @property profile H265 profile.
 * @property qvbrQualityLevel Controls the target quality for the video encode.
 * @property rateControlMode Rate control mode.
 * @property scanType Sets the scan type of the output.
 * @property sceneChangeDetect Scene change detection.
 * @property slices Number of slices per picture.
 * @property tier Set the H265 tier in the output.
 * @property timecodeBurninSettings Apply a burned in timecode. See H265 Timecode Burnin Settings for more details.
 * @property timecodeInsertion Determines how timecodes should be inserted into the video elementary stream.
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs(
    public val adaptiveQuantization: Output<String>? = null,
    public val afdSignaling: Output<String>? = null,
    public val alternativeTransferFunction: Output<String>? = null,
    public val bitrate: Output<Int>,
    public val bufSize: Output<Int>? = null,
    public val colorMetadata: Output<String>? = null,
    public val colorSpaceSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs>? =
        null,
    public val filterSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgs>? =
        null,
    public val fixedAfd: Output<String>? = null,
    public val flickerAq: Output<String>? = null,
    public val framerateDenominator: Output<Int>,
    public val framerateNumerator: Output<Int>,
    public val gopClosedCadence: Output<Int>? = null,
    public val gopSize: Output<Double>? = null,
    public val gopSizeUnits: Output<String>? = null,
    public val level: Output<String>? = null,
    public val lookAheadRateControl: Output<String>? = null,
    public val maxBitrate: Output<Int>? = null,
    public val minIInterval: Output<Int>? = null,
    public val parDenominator: Output<Int>? = null,
    public val parNumerator: Output<Int>? = null,
    public val profile: Output<String>? = null,
    public val qvbrQualityLevel: Output<Int>? = null,
    public val rateControlMode: Output<String>? = null,
    public val scanType: Output<String>? = null,
    public val sceneChangeDetect: Output<String>? = null,
    public val slices: Output<Int>? = null,
    public val tier: Output<String>? = null,
    public val timecodeBurninSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs>? =
        null,
    public val timecodeInsertion: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs.builder()
            .adaptiveQuantization(adaptiveQuantization?.applyValue({ args0 -> args0 }))
            .afdSignaling(afdSignaling?.applyValue({ args0 -> args0 }))
            .alternativeTransferFunction(alternativeTransferFunction?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate.applyValue({ args0 -> args0 }))
            .bufSize(bufSize?.applyValue({ args0 -> args0 }))
            .colorMetadata(colorMetadata?.applyValue({ args0 -> args0 }))
            .colorSpaceSettings(
                colorSpaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filterSettings(filterSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .fixedAfd(fixedAfd?.applyValue({ args0 -> args0 }))
            .flickerAq(flickerAq?.applyValue({ args0 -> args0 }))
            .framerateDenominator(framerateDenominator.applyValue({ args0 -> args0 }))
            .framerateNumerator(framerateNumerator.applyValue({ args0 -> args0 }))
            .gopClosedCadence(gopClosedCadence?.applyValue({ args0 -> args0 }))
            .gopSize(gopSize?.applyValue({ args0 -> args0 }))
            .gopSizeUnits(gopSizeUnits?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 }))
            .lookAheadRateControl(lookAheadRateControl?.applyValue({ args0 -> args0 }))
            .maxBitrate(maxBitrate?.applyValue({ args0 -> args0 }))
            .minIInterval(minIInterval?.applyValue({ args0 -> args0 }))
            .parDenominator(parDenominator?.applyValue({ args0 -> args0 }))
            .parNumerator(parNumerator?.applyValue({ args0 -> args0 }))
            .profile(profile?.applyValue({ args0 -> args0 }))
            .qvbrQualityLevel(qvbrQualityLevel?.applyValue({ args0 -> args0 }))
            .rateControlMode(rateControlMode?.applyValue({ args0 -> args0 }))
            .scanType(scanType?.applyValue({ args0 -> args0 }))
            .sceneChangeDetect(sceneChangeDetect?.applyValue({ args0 -> args0 }))
            .slices(slices?.applyValue({ args0 -> args0 }))
            .tier(tier?.applyValue({ args0 -> args0 }))
            .timecodeBurninSettings(
                timecodeBurninSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .timecodeInsertion(timecodeInsertion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgsBuilder internal constructor() {
    private var adaptiveQuantization: Output<String>? = null

    private var afdSignaling: Output<String>? = null

    private var alternativeTransferFunction: Output<String>? = null

    private var bitrate: Output<Int>? = null

    private var bufSize: Output<Int>? = null

    private var colorMetadata: Output<String>? = null

    private var colorSpaceSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs>? =
        null

    private var filterSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgs>? =
        null

    private var fixedAfd: Output<String>? = null

    private var flickerAq: Output<String>? = null

    private var framerateDenominator: Output<Int>? = null

    private var framerateNumerator: Output<Int>? = null

    private var gopClosedCadence: Output<Int>? = null

    private var gopSize: Output<Double>? = null

    private var gopSizeUnits: Output<String>? = null

    private var level: Output<String>? = null

    private var lookAheadRateControl: Output<String>? = null

    private var maxBitrate: Output<Int>? = null

    private var minIInterval: Output<Int>? = null

    private var parDenominator: Output<Int>? = null

    private var parNumerator: Output<Int>? = null

    private var profile: Output<String>? = null

    private var qvbrQualityLevel: Output<Int>? = null

    private var rateControlMode: Output<String>? = null

    private var scanType: Output<String>? = null

    private var sceneChangeDetect: Output<String>? = null

    private var slices: Output<Int>? = null

    private var tier: Output<String>? = null

    private var timecodeBurninSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs>? =
        null

    private var timecodeInsertion: Output<String>? = null

    /**
     * @param value Enables or disables adaptive quantization.
     */
    @JvmName("kovhgyutosndbcii")
    public suspend fun adaptiveQuantization(`value`: Output<String>) {
        this.adaptiveQuantization = value
    }

    /**
     * @param value Indicates that AFD values will be written into the output stream.
     */
    @JvmName("vqaojgfkxtwmgtaw")
    public suspend fun afdSignaling(`value`: Output<String>) {
        this.afdSignaling = value
    }

    /**
     * @param value Whether or not EML should insert an Alternative Transfer Function SEI message.
     */
    @JvmName("npwxulypxbelvuey")
    public suspend fun alternativeTransferFunction(`value`: Output<String>) {
        this.alternativeTransferFunction = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("yeintumbkbxpgdsr")
    public suspend fun bitrate(`value`: Output<Int>) {
        this.bitrate = value
    }

    /**
     * @param value Size of buffer in bits.
     */
    @JvmName("wfjntlqdmugfiekb")
    public suspend fun bufSize(`value`: Output<Int>) {
        this.bufSize = value
    }

    /**
     * @param value Includes color space metadata in the output.
     */
    @JvmName("wdffyrwkffmthqxj")
    public suspend fun colorMetadata(`value`: Output<String>) {
        this.colorMetadata = value
    }

    /**
     * @param value Define the color metadata for the output. H265 Color Space Settings for more details.
     */
    @JvmName("tjxwjbvssnehjhpt")
    public suspend fun colorSpaceSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs>) {
        this.colorSpaceSettings = value
    }

    /**
     * @param value Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("xvqsjsyudjdoxkgl")
    public suspend fun filterSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgs>) {
        this.filterSettings = value
    }

    /**
     * @param value Four bit AFD value to write on all frames of video in the output stream.
     */
    @JvmName("icsvnbnnitvhcllo")
    public suspend fun fixedAfd(`value`: Output<String>) {
        this.fixedAfd = value
    }

    /**
     * @param value
     */
    @JvmName("jtsdesbbowhlboer")
    public suspend fun flickerAq(`value`: Output<String>) {
        this.flickerAq = value
    }

    /**
     * @param value Framerate denominator.
     */
    @JvmName("ldkfqwvmehpkacib")
    public suspend fun framerateDenominator(`value`: Output<Int>) {
        this.framerateDenominator = value
    }

    /**
     * @param value Framerate numerator.
     */
    @JvmName("kpusdrsyapbfxgkg")
    public suspend fun framerateNumerator(`value`: Output<Int>) {
        this.framerateNumerator = value
    }

    /**
     * @param value Frequency of closed GOPs.
     */
    @JvmName("nnwkyuyrcsisbqeh")
    public suspend fun gopClosedCadence(`value`: Output<Int>) {
        this.gopClosedCadence = value
    }

    /**
     * @param value GOP size in units of either frames of seconds per `gop_size_units`.
     */
    @JvmName("jkdfbnmcetisyryp")
    public suspend fun gopSize(`value`: Output<Double>) {
        this.gopSize = value
    }

    /**
     * @param value Indicates if the `gop_size` is specified in frames or seconds.
     */
    @JvmName("jlvcsqmlrjhquopg")
    public suspend fun gopSizeUnits(`value`: Output<String>) {
        this.gopSizeUnits = value
    }

    /**
     * @param value H265 level.
     */
    @JvmName("pggmyievscbmnmkx")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value Amount of lookahead.
     */
    @JvmName("ugaxrklxjtjsjjhs")
    public suspend fun lookAheadRateControl(`value`: Output<String>) {
        this.lookAheadRateControl = value
    }

    /**
     * @param value Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    @JvmName("uidgocinxdpqknpa")
    public suspend fun maxBitrate(`value`: Output<Int>) {
        this.maxBitrate = value
    }

    /**
     * @param value
     */
    @JvmName("ulfdghgoxjqedbbr")
    public suspend fun minIInterval(`value`: Output<Int>) {
        this.minIInterval = value
    }

    /**
     * @param value Pixel Aspect Ratio denominator.
     */
    @JvmName("flbdbvtygtdpmolj")
    public suspend fun parDenominator(`value`: Output<Int>) {
        this.parDenominator = value
    }

    /**
     * @param value Pixel Aspect Ratio numerator.
     */
    @JvmName("vbvgoykpakdsegcu")
    public suspend fun parNumerator(`value`: Output<Int>) {
        this.parNumerator = value
    }

    /**
     * @param value H265 profile.
     */
    @JvmName("txockovkdmgoxirt")
    public suspend fun profile(`value`: Output<String>) {
        this.profile = value
    }

    /**
     * @param value Controls the target quality for the video encode.
     */
    @JvmName("sigojocqdmrkcvlw")
    public suspend fun qvbrQualityLevel(`value`: Output<Int>) {
        this.qvbrQualityLevel = value
    }

    /**
     * @param value Rate control mode.
     */
    @JvmName("kudrtuvmpujkenov")
    public suspend fun rateControlMode(`value`: Output<String>) {
        this.rateControlMode = value
    }

    /**
     * @param value Sets the scan type of the output.
     */
    @JvmName("aqjatpxjpvtahrry")
    public suspend fun scanType(`value`: Output<String>) {
        this.scanType = value
    }

    /**
     * @param value Scene change detection.
     */
    @JvmName("xyndhsowirohnrnr")
    public suspend fun sceneChangeDetect(`value`: Output<String>) {
        this.sceneChangeDetect = value
    }

    /**
     * @param value Number of slices per picture.
     */
    @JvmName("nrlivlspsllnbiyu")
    public suspend fun slices(`value`: Output<Int>) {
        this.slices = value
    }

    /**
     * @param value Set the H265 tier in the output.
     */
    @JvmName("bupwnojrdyfudvae")
    public suspend fun tier(`value`: Output<String>) {
        this.tier = value
    }

    /**
     * @param value Apply a burned in timecode. See H265 Timecode Burnin Settings for more details.
     */
    @JvmName("prfbmapydyuygoer")
    public suspend fun timecodeBurninSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs>) {
        this.timecodeBurninSettings = value
    }

    /**
     * @param value Determines how timecodes should be inserted into the video elementary stream.
     */
    @JvmName("jitsioycyyffnjla")
    public suspend fun timecodeInsertion(`value`: Output<String>) {
        this.timecodeInsertion = value
    }

    /**
     * @param value Enables or disables adaptive quantization.
     */
    @JvmName("gkuacvrlbkasxfoj")
    public suspend fun adaptiveQuantization(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adaptiveQuantization = mapped
    }

    /**
     * @param value Indicates that AFD values will be written into the output stream.
     */
    @JvmName("nmeyjdssxafpjhny")
    public suspend fun afdSignaling(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.afdSignaling = mapped
    }

    /**
     * @param value Whether or not EML should insert an Alternative Transfer Function SEI message.
     */
    @JvmName("qlxshykkvpwgsdlm")
    public suspend fun alternativeTransferFunction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternativeTransferFunction = mapped
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("pjmvtdedsxlxxwxy")
    public suspend fun bitrate(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Size of buffer in bits.
     */
    @JvmName("cetfrymeajtkwrvy")
    public suspend fun bufSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufSize = mapped
    }

    /**
     * @param value Includes color space metadata in the output.
     */
    @JvmName("totdykchyymxrqar")
    public suspend fun colorMetadata(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorMetadata = mapped
    }

    /**
     * @param value Define the color metadata for the output. H265 Color Space Settings for more details.
     */
    @JvmName("qhgcteownbwmxbam")
    public suspend fun colorSpaceSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorSpaceSettings = mapped
    }

    /**
     * @param argument Define the color metadata for the output. H265 Color Space Settings for more details.
     */
    @JvmName("vlcwocihjnvslppe")
    public suspend fun colorSpaceSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.colorSpaceSettings = mapped
    }

    /**
     * @param value Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("ibkfubyuegyvkocc")
    public suspend fun filterSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterSettings = mapped
    }

    /**
     * @param argument Filters to apply to an encode. See H265 Filter Settings for more details.
     */
    @JvmName("rdxqsikvqqsivmab")
    public suspend fun filterSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsFilterSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.filterSettings = mapped
    }

    /**
     * @param value Four bit AFD value to write on all frames of video in the output stream.
     */
    @JvmName("udvwppdsrbldhyrq")
    public suspend fun fixedAfd(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fixedAfd = mapped
    }

    /**
     * @param value
     */
    @JvmName("xabhqdvqgepiotfg")
    public suspend fun flickerAq(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.flickerAq = mapped
    }

    /**
     * @param value Framerate denominator.
     */
    @JvmName("wjtnlgwutynbvpkt")
    public suspend fun framerateDenominator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.framerateDenominator = mapped
    }

    /**
     * @param value Framerate numerator.
     */
    @JvmName("vijkcplbwvxflcsj")
    public suspend fun framerateNumerator(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.framerateNumerator = mapped
    }

    /**
     * @param value Frequency of closed GOPs.
     */
    @JvmName("xgavcsocracgwxbv")
    public suspend fun gopClosedCadence(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopClosedCadence = mapped
    }

    /**
     * @param value GOP size in units of either frames of seconds per `gop_size_units`.
     */
    @JvmName("ykirojpnvneyebcn")
    public suspend fun gopSize(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopSize = mapped
    }

    /**
     * @param value Indicates if the `gop_size` is specified in frames or seconds.
     */
    @JvmName("mwojkrakeaaxvcwr")
    public suspend fun gopSizeUnits(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gopSizeUnits = mapped
    }

    /**
     * @param value H265 level.
     */
    @JvmName("xtplxkkprfuleipv")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    /**
     * @param value Amount of lookahead.
     */
    @JvmName("ilghfmejnldookcj")
    public suspend fun lookAheadRateControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lookAheadRateControl = mapped
    }

    /**
     * @param value Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
     */
    @JvmName("imkuuusijvnghhpa")
    public suspend fun maxBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxBitrate = mapped
    }

    /**
     * @param value
     */
    @JvmName("wkggblhxmjotsrkv")
    public suspend fun minIInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minIInterval = mapped
    }

    /**
     * @param value Pixel Aspect Ratio denominator.
     */
    @JvmName("aeweeurmbwyepgnr")
    public suspend fun parDenominator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parDenominator = mapped
    }

    /**
     * @param value Pixel Aspect Ratio numerator.
     */
    @JvmName("kpiwjfkgeltrfgsh")
    public suspend fun parNumerator(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parNumerator = mapped
    }

    /**
     * @param value H265 profile.
     */
    @JvmName("ccaacfflxidvrxln")
    public suspend fun profile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.profile = mapped
    }

    /**
     * @param value Controls the target quality for the video encode.
     */
    @JvmName("iqqhowvdlbjhgbuk")
    public suspend fun qvbrQualityLevel(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qvbrQualityLevel = mapped
    }

    /**
     * @param value Rate control mode.
     */
    @JvmName("bagbpodxxrwguesu")
    public suspend fun rateControlMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rateControlMode = mapped
    }

    /**
     * @param value Sets the scan type of the output.
     */
    @JvmName("ehsvihfgfhovyafq")
    public suspend fun scanType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scanType = mapped
    }

    /**
     * @param value Scene change detection.
     */
    @JvmName("lensytnwhhuaxfco")
    public suspend fun sceneChangeDetect(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sceneChangeDetect = mapped
    }

    /**
     * @param value Number of slices per picture.
     */
    @JvmName("ikysslkiujwyaihx")
    public suspend fun slices(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slices = mapped
    }

    /**
     * @param value Set the H265 tier in the output.
     */
    @JvmName("ktovkfpttqbarwmn")
    public suspend fun tier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Apply a burned in timecode. See H265 Timecode Burnin Settings for more details.
     */
    @JvmName("rflogejbqtttlvid")
    public suspend fun timecodeBurninSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timecodeBurninSettings = mapped
    }

    /**
     * @param argument Apply a burned in timecode. See H265 Timecode Burnin Settings for more details.
     */
    @JvmName("njqwdtgcilytkaen")
    public suspend fun timecodeBurninSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsTimecodeBurninSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.timecodeBurninSettings = mapped
    }

    /**
     * @param value Determines how timecodes should be inserted into the video elementary stream.
     */
    @JvmName("pfxuhsqaatgnycxf")
    public suspend fun timecodeInsertion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timecodeInsertion = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsArgs(
            adaptiveQuantization = adaptiveQuantization,
            afdSignaling = afdSignaling,
            alternativeTransferFunction = alternativeTransferFunction,
            bitrate = bitrate ?: throw PulumiNullFieldException("bitrate"),
            bufSize = bufSize,
            colorMetadata = colorMetadata,
            colorSpaceSettings = colorSpaceSettings,
            filterSettings = filterSettings,
            fixedAfd = fixedAfd,
            flickerAq = flickerAq,
            framerateDenominator = framerateDenominator ?: throw
                PulumiNullFieldException("framerateDenominator"),
            framerateNumerator = framerateNumerator ?: throw PulumiNullFieldException("framerateNumerator"),
            gopClosedCadence = gopClosedCadence,
            gopSize = gopSize,
            gopSizeUnits = gopSizeUnits,
            level = level,
            lookAheadRateControl = lookAheadRateControl,
            maxBitrate = maxBitrate,
            minIInterval = minIInterval,
            parDenominator = parDenominator,
            parNumerator = parNumerator,
            profile = profile,
            qvbrQualityLevel = qvbrQualityLevel,
            rateControlMode = rateControlMode,
            scanType = scanType,
            sceneChangeDetect = sceneChangeDetect,
            slices = slices,
            tier = tier,
            timecodeBurninSettings = timecodeBurninSettings,
            timecodeInsertion = timecodeInsertion,
        )
}
