@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property colorSpacePassthroughSettings Sets the colorspace metadata to be passed through.
 * @property dolbyVision81Settings Set the colorspace to Dolby Vision81.
 * @property hdr10Settings Set the colorspace to be HDR10. See H265 HDR10 Settings for more details.
 * @property rec601Settings Set the colorspace to Rec. 601.
 * @property rec709Settings Set the colorspace to Rec. 709.
 */
public data class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs(
    public val colorSpacePassthroughSettings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgs>? =
        null,
    public val dolbyVision81Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgs>? =
        null,
    public val hdr10Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs>? =
        null,
    public val rec601Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgs>? =
        null,
    public val rec709Settings: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs.builder()
            .colorSpacePassthroughSettings(
                colorSpacePassthroughSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .dolbyVision81Settings(
                dolbyVision81Settings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .hdr10Settings(hdr10Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rec601Settings(rec601Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .rec709Settings(
                rec709Settings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgsBuilder
internal constructor() {
    private var colorSpacePassthroughSettings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgs>? =
        null

    private var dolbyVision81Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgs>? =
        null

    private var hdr10Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs>? =
        null

    private var rec601Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgs>? =
        null

    private var rec709Settings:
        Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgs>? =
        null

    /**
     * @param value Sets the colorspace metadata to be passed through.
     */
    @JvmName("ryfsqyflvpiracvc")
    public suspend fun colorSpacePassthroughSettings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgs>) {
        this.colorSpacePassthroughSettings = value
    }

    /**
     * @param value Set the colorspace to Dolby Vision81.
     */
    @JvmName("crppgmsaddnxdxon")
    public suspend fun dolbyVision81Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgs>) {
        this.dolbyVision81Settings = value
    }

    /**
     * @param value Set the colorspace to be HDR10. See H265 HDR10 Settings for more details.
     */
    @JvmName("ungthgpakvgjafjb")
    public suspend fun hdr10Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs>) {
        this.hdr10Settings = value
    }

    /**
     * @param value Set the colorspace to Rec. 601.
     */
    @JvmName("fifbpyaybxcnkrtj")
    public suspend fun rec601Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgs>) {
        this.rec601Settings = value
    }

    /**
     * @param value Set the colorspace to Rec. 709.
     */
    @JvmName("ucxwtdavuffksjii")
    public suspend fun rec709Settings(`value`: Output<ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgs>) {
        this.rec709Settings = value
    }

    /**
     * @param value Sets the colorspace metadata to be passed through.
     */
    @JvmName("mnktswimwamseqxa")
    public suspend fun colorSpacePassthroughSettings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.colorSpacePassthroughSettings = mapped
    }

    /**
     * @param argument Sets the colorspace metadata to be passed through.
     */
    @JvmName("mkgwcxqkgmqguwoo")
    public suspend fun colorSpacePassthroughSettings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.colorSpacePassthroughSettings = mapped
    }

    /**
     * @param value Set the colorspace to Dolby Vision81.
     */
    @JvmName("ofqxqsauoromvfnn")
    public suspend fun dolbyVision81Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dolbyVision81Settings = mapped
    }

    /**
     * @param argument Set the colorspace to Dolby Vision81.
     */
    @JvmName("ccjjnkdlmbqiogkm")
    public suspend fun dolbyVision81Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dolbyVision81Settings = mapped
    }

    /**
     * @param value Set the colorspace to be HDR10. See H265 HDR10 Settings for more details.
     */
    @JvmName("qplgqpfauircohcm")
    public suspend fun hdr10Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hdr10Settings = mapped
    }

    /**
     * @param argument Set the colorspace to be HDR10. See H265 HDR10 Settings for more details.
     */
    @JvmName("uivlbtvceuroxohm")
    public suspend fun hdr10Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.hdr10Settings = mapped
    }

    /**
     * @param value Set the colorspace to Rec. 601.
     */
    @JvmName("ofbadoisxtoddhnm")
    public suspend fun rec601Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rec601Settings = mapped
    }

    /**
     * @param argument Set the colorspace to Rec. 601.
     */
    @JvmName("biddhuafwfppynix")
    public suspend fun rec601Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rec601Settings = mapped
    }

    /**
     * @param value Set the colorspace to Rec. 709.
     */
    @JvmName("jdqphdlnfeqhullt")
    public suspend fun rec709Settings(`value`: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rec709Settings = mapped
    }

    /**
     * @param argument Set the colorspace to Rec. 709.
     */
    @JvmName("svknjfxdafvoanoi")
    public suspend fun rec709Settings(argument: suspend ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rec709Settings = mapped
    }

    internal fun build(): ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs =
        ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsArgs(
            colorSpacePassthroughSettings = colorSpacePassthroughSettings,
            dolbyVision81Settings = dolbyVision81Settings,
            hdr10Settings = hdr10Settings,
            rec601Settings = rec601Settings,
            rec709Settings = rec709Settings,
        )
}
