@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property errorClearTimeMsec This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input\_preference for the failover pair is set to PRIMARY\_INPUT\_PREFERRED, because after this time, MediaLive will switch back to the primary input.
 * @property failoverConditions A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
 * @property inputPreference Input preference when deciding which input to make active when a previously failed input has recovered.
 * @property secondaryInputId The input ID of the secondary input in the automatic input failover pair.
 */
public data class ChannelInputAttachmentAutomaticInputFailoverSettingsArgs(
    public val errorClearTimeMsec: Output<Int>? = null,
    public val failoverConditions: Output<List<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>>? =
        null,
    public val inputPreference: Output<String>? = null,
    public val secondaryInputId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsArgs.builder()
            .errorClearTimeMsec(errorClearTimeMsec?.applyValue({ args0 -> args0 }))
            .failoverConditions(
                failoverConditions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .inputPreference(inputPreference?.applyValue({ args0 -> args0 }))
            .secondaryInputId(secondaryInputId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentAutomaticInputFailoverSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentAutomaticInputFailoverSettingsArgsBuilder internal constructor() {
    private var errorClearTimeMsec: Output<Int>? = null

    private var failoverConditions:
        Output<List<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>>? =
        null

    private var inputPreference: Output<String>? = null

    private var secondaryInputId: Output<String>? = null

    /**
     * @param value This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input\_preference for the failover pair is set to PRIMARY\_INPUT\_PREFERRED, because after this time, MediaLive will switch back to the primary input.
     */
    @JvmName("jrykjfiuvwdxhorr")
    public suspend fun errorClearTimeMsec(`value`: Output<Int>) {
        this.errorClearTimeMsec = value
    }

    /**
     * @param value A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("xwiquncvxqdxqbwr")
    public suspend fun failoverConditions(`value`: Output<List<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>>) {
        this.failoverConditions = value
    }

    @JvmName("yjavcreihgjwqbug")
    public suspend fun failoverConditions(vararg values: Output<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>) {
        this.failoverConditions = Output.all(values.asList())
    }

    /**
     * @param values A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("solguqxeartuqdgg")
    public suspend fun failoverConditions(values: List<Output<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>>) {
        this.failoverConditions = Output.all(values)
    }

    /**
     * @param value Input preference when deciding which input to make active when a previously failed input has recovered.
     */
    @JvmName("hptmhpsdyuvfvetg")
    public suspend fun inputPreference(`value`: Output<String>) {
        this.inputPreference = value
    }

    /**
     * @param value The input ID of the secondary input in the automatic input failover pair.
     */
    @JvmName("njismwvppyniaypc")
    public suspend fun secondaryInputId(`value`: Output<String>) {
        this.secondaryInputId = value
    }

    /**
     * @param value This clear time defines the requirement a recovered input must meet to be considered healthy. The input must have no failover conditions for this length of time. Enter a time in milliseconds. This value is particularly important if the input\_preference for the failover pair is set to PRIMARY\_INPUT\_PREFERRED, because after this time, MediaLive will switch back to the primary input.
     */
    @JvmName("uaqbuofaglncaxeo")
    public suspend fun errorClearTimeMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errorClearTimeMsec = mapped
    }

    /**
     * @param value A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("meaamdcgrwxnulee")
    public suspend fun failoverConditions(`value`: List<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverConditions = mapped
    }

    /**
     * @param argument A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("enwcvaxaaorllsac")
    public suspend fun failoverConditions(argument: List<suspend ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverConditions = mapped
    }

    /**
     * @param argument A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("fnkmgmdltvbjtfuo")
    public suspend fun failoverConditions(vararg argument: suspend ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.failoverConditions = mapped
    }

    /**
     * @param argument A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("onwpkngtkeoiqkwv")
    public suspend fun failoverConditions(argument: suspend ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.failoverConditions = mapped
    }

    /**
     * @param values A list of failover conditions. If any of these conditions occur, MediaLive will perform a failover to the other input. See Failover Condition Block for more details.
     */
    @JvmName("bmmutnocjtnsxmhl")
    public suspend fun failoverConditions(vararg values: ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverConditions = mapped
    }

    /**
     * @param value Input preference when deciding which input to make active when a previously failed input has recovered.
     */
    @JvmName("smtapuhcexxdsuip")
    public suspend fun inputPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputPreference = mapped
    }

    /**
     * @param value The input ID of the secondary input in the automatic input failover pair.
     */
    @JvmName("offqthinienrgkxi")
    public suspend fun secondaryInputId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secondaryInputId = mapped
    }

    internal fun build(): ChannelInputAttachmentAutomaticInputFailoverSettingsArgs =
        ChannelInputAttachmentAutomaticInputFailoverSettingsArgs(
            errorClearTimeMsec = errorClearTimeMsec,
            failoverConditions = failoverConditions,
            inputPreference = inputPreference,
            secondaryInputId = secondaryInputId ?: throw PulumiNullFieldException("secondaryInputId"),
        )
}
