@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property failoverConditionSettings Failover condition type-specific settings. See Failover Condition Settings for more details.
 */
public data class ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs(
    public val failoverConditionSettings: Output<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs.builder()
            .failoverConditionSettings(
                failoverConditionSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgsBuilder
internal constructor() {
    private var failoverConditionSettings:
        Output<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgs>? =
        null

    /**
     * @param value Failover condition type-specific settings. See Failover Condition Settings for more details.
     */
    @JvmName("twdgptggmrlqnamq")
    public suspend fun failoverConditionSettings(`value`: Output<ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgs>) {
        this.failoverConditionSettings = value
    }

    /**
     * @param value Failover condition type-specific settings. See Failover Condition Settings for more details.
     */
    @JvmName("kbfscwnlnocjcbuh")
    public suspend fun failoverConditionSettings(`value`: ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverConditionSettings = mapped
    }

    /**
     * @param argument Failover condition type-specific settings. See Failover Condition Settings for more details.
     */
    @JvmName("eqodufjnhdghfegk")
    public suspend fun failoverConditionSettings(argument: suspend ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.failoverConditionSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs =
        ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionArgs(
            failoverConditionSettings = failoverConditionSettings,
        )
}
