@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property audioSelectorName
 * @property audioSilenceThresholdMsec The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
 */
public data class
ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs(
    public val audioSelectorName: Output<String>,
    public val audioSilenceThresholdMsec: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs.builder()
            .audioSelectorName(audioSelectorName.applyValue({ args0 -> args0 }))
            .audioSilenceThresholdMsec(audioSilenceThresholdMsec?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgsBuilder
internal constructor() {
    private var audioSelectorName: Output<String>? = null

    private var audioSilenceThresholdMsec: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("kiqwdnhvlphekbpd")
    public suspend fun audioSelectorName(`value`: Output<String>) {
        this.audioSelectorName = value
    }

    /**
     * @param value The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
     */
    @JvmName("whephnxupysvxynj")
    public suspend fun audioSilenceThresholdMsec(`value`: Output<Int>) {
        this.audioSilenceThresholdMsec = value
    }

    /**
     * @param value
     */
    @JvmName("vdpxsofjujsqmisw")
    public suspend fun audioSelectorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioSelectorName = mapped
    }

    /**
     * @param value The amount of time (in milliseconds) that the active input must be silent before automatic input failover occurs. Silence is defined as audio loss or audio quieter than -50 dBFS.
     */
    @JvmName("yuqbdvfyjhvmkxvq")
    public suspend fun audioSilenceThresholdMsec(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioSilenceThresholdMsec = mapped
    }

    internal fun build(): ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs =
        ChannelInputAttachmentAutomaticInputFailoverSettingsFailoverConditionFailoverConditionSettingsAudioSilenceSettingsArgs(
            audioSelectorName = audioSelectorName ?: throw PulumiNullFieldException("audioSelectorName"),
            audioSilenceThresholdMsec = audioSilenceThresholdMsec,
        )
}
