@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audioSelectors Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
 * @property captionSelectors Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
 * @property deblockFilter Enable or disable the deblock filter when filtering.
 * @property denoiseFilter Enable or disable the denoise filter when filtering.
 * @property filterStrength Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
 * @property inputFilter Turns on the filter for the input.
 * @property networkInputSettings Input settings. See Network Input Settings for more details.
 * @property scte35Pid PID from which to read SCTE-35 messages.
 * @property smpte2038DataPreference Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in the input.
 * @property sourceEndBehavior Loop input if it is a file.
 * @property videoSelector
 */
public data class ChannelInputAttachmentInputSettingsArgs(
    public val audioSelectors: Output<List<ChannelInputAttachmentInputSettingsAudioSelectorArgs>>? =
        null,
    public val captionSelectors: Output<List<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>>? =
        null,
    public val deblockFilter: Output<String>? = null,
    public val denoiseFilter: Output<String>? = null,
    public val filterStrength: Output<Int>? = null,
    public val inputFilter: Output<String>? = null,
    public val networkInputSettings: Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs>? = null,
    public val scte35Pid: Output<Int>? = null,
    public val smpte2038DataPreference: Output<String>? = null,
    public val sourceEndBehavior: Output<String>? = null,
    public val videoSelector: Output<ChannelInputAttachmentInputSettingsVideoSelectorArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsArgs.builder()
            .audioSelectors(
                audioSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .captionSelectors(
                captionSelectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .deblockFilter(deblockFilter?.applyValue({ args0 -> args0 }))
            .denoiseFilter(denoiseFilter?.applyValue({ args0 -> args0 }))
            .filterStrength(filterStrength?.applyValue({ args0 -> args0 }))
            .inputFilter(inputFilter?.applyValue({ args0 -> args0 }))
            .networkInputSettings(
                networkInputSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .scte35Pid(scte35Pid?.applyValue({ args0 -> args0 }))
            .smpte2038DataPreference(smpte2038DataPreference?.applyValue({ args0 -> args0 }))
            .sourceEndBehavior(sourceEndBehavior?.applyValue({ args0 -> args0 }))
            .videoSelector(videoSelector?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsArgsBuilder internal constructor() {
    private var audioSelectors: Output<List<ChannelInputAttachmentInputSettingsAudioSelectorArgs>>? =
        null

    private var captionSelectors:
        Output<List<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>>? = null

    private var deblockFilter: Output<String>? = null

    private var denoiseFilter: Output<String>? = null

    private var filterStrength: Output<Int>? = null

    private var inputFilter: Output<String>? = null

    private var networkInputSettings:
        Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs>? = null

    private var scte35Pid: Output<Int>? = null

    private var smpte2038DataPreference: Output<String>? = null

    private var sourceEndBehavior: Output<String>? = null

    private var videoSelector: Output<ChannelInputAttachmentInputSettingsVideoSelectorArgs>? = null

    /**
     * @param value Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("vcbkwulqxrbyuyjr")
    public suspend fun audioSelectors(`value`: Output<List<ChannelInputAttachmentInputSettingsAudioSelectorArgs>>) {
        this.audioSelectors = value
    }

    @JvmName("gqwhmhtmavbnrhxr")
    public suspend fun audioSelectors(vararg values: Output<ChannelInputAttachmentInputSettingsAudioSelectorArgs>) {
        this.audioSelectors = Output.all(values.asList())
    }

    /**
     * @param values Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("yibtalmigrpcglkx")
    public suspend fun audioSelectors(values: List<Output<ChannelInputAttachmentInputSettingsAudioSelectorArgs>>) {
        this.audioSelectors = Output.all(values)
    }

    /**
     * @param value Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("hwuytfuyjcxwswqs")
    public suspend fun captionSelectors(`value`: Output<List<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>>) {
        this.captionSelectors = value
    }

    @JvmName("hctolsfxkmispsgn")
    public suspend fun captionSelectors(vararg values: Output<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>) {
        this.captionSelectors = Output.all(values.asList())
    }

    /**
     * @param values Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("mweguhahfdyhyipq")
    public suspend fun captionSelectors(values: List<Output<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>>) {
        this.captionSelectors = Output.all(values)
    }

    /**
     * @param value Enable or disable the deblock filter when filtering.
     */
    @JvmName("vngoucfieyuccsvs")
    public suspend fun deblockFilter(`value`: Output<String>) {
        this.deblockFilter = value
    }

    /**
     * @param value Enable or disable the denoise filter when filtering.
     */
    @JvmName("cvgdnvejlufavjtn")
    public suspend fun denoiseFilter(`value`: Output<String>) {
        this.denoiseFilter = value
    }

    /**
     * @param value Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
     */
    @JvmName("ntchppsweldpxjmp")
    public suspend fun filterStrength(`value`: Output<Int>) {
        this.filterStrength = value
    }

    /**
     * @param value Turns on the filter for the input.
     */
    @JvmName("knjwhvhmgkisulnw")
    public suspend fun inputFilter(`value`: Output<String>) {
        this.inputFilter = value
    }

    /**
     * @param value Input settings. See Network Input Settings for more details.
     */
    @JvmName("qlmylmwtlfcrukwd")
    public suspend fun networkInputSettings(`value`: Output<ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs>) {
        this.networkInputSettings = value
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("qfbsesqlnvfiessh")
    public suspend fun scte35Pid(`value`: Output<Int>) {
        this.scte35Pid = value
    }

    /**
     * @param value Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in the input.
     */
    @JvmName("inwnkdanyeyahhuu")
    public suspend fun smpte2038DataPreference(`value`: Output<String>) {
        this.smpte2038DataPreference = value
    }

    /**
     * @param value Loop input if it is a file.
     */
    @JvmName("yjwqnsiuqmjjaxcf")
    public suspend fun sourceEndBehavior(`value`: Output<String>) {
        this.sourceEndBehavior = value
    }

    /**
     * @param value
     */
    @JvmName("wdjqodxuujviyfji")
    public suspend fun videoSelector(`value`: Output<ChannelInputAttachmentInputSettingsVideoSelectorArgs>) {
        this.videoSelector = value
    }

    /**
     * @param value Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("tenigkyjphwocqde")
    public suspend fun audioSelectors(`value`: List<ChannelInputAttachmentInputSettingsAudioSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioSelectors = mapped
    }

    /**
     * @param argument Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("devrdakkndqobapc")
    public suspend fun audioSelectors(argument: List<suspend ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioSelectors = mapped
    }

    /**
     * @param argument Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("tqnwpvfvtdufpayg")
    public suspend fun audioSelectors(vararg argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioSelectors = mapped
    }

    /**
     * @param argument Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("qnepxriieoajeaor")
    public suspend fun audioSelectors(argument: suspend ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelInputAttachmentInputSettingsAudioSelectorArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.audioSelectors = mapped
    }

    /**
     * @param values Used to select the audio stream to decode for inputs that have multiple. See Audio Selectors for more details.
     */
    @JvmName("xvbrymyfbfnviqex")
    public suspend fun audioSelectors(vararg values: ChannelInputAttachmentInputSettingsAudioSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioSelectors = mapped
    }

    /**
     * @param value Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("iqyxxooswkoicgwd")
    public suspend fun captionSelectors(`value`: List<ChannelInputAttachmentInputSettingsCaptionSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionSelectors = mapped
    }

    /**
     * @param argument Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("wrbxcggrpmuwbhab")
    public suspend fun captionSelectors(argument: List<suspend ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionSelectors = mapped
    }

    /**
     * @param argument Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("jhseailtjpshacec")
    public suspend fun captionSelectors(vararg argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionSelectors = mapped
    }

    /**
     * @param argument Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("gajcsvlhyehafett")
    public suspend fun captionSelectors(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.captionSelectors = mapped
    }

    /**
     * @param values Used to select the caption input to use for inputs that have multiple available. See Caption Selectors for more details.
     */
    @JvmName("awjktwatgstavgwe")
    public suspend fun captionSelectors(vararg values: ChannelInputAttachmentInputSettingsCaptionSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionSelectors = mapped
    }

    /**
     * @param value Enable or disable the deblock filter when filtering.
     */
    @JvmName("bguxtuxbrwabmmqc")
    public suspend fun deblockFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deblockFilter = mapped
    }

    /**
     * @param value Enable or disable the denoise filter when filtering.
     */
    @JvmName("qpsewviqaqfwhlln")
    public suspend fun denoiseFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denoiseFilter = mapped
    }

    /**
     * @param value Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
     */
    @JvmName("nhkbqswudpskgryy")
    public suspend fun filterStrength(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterStrength = mapped
    }

    /**
     * @param value Turns on the filter for the input.
     */
    @JvmName("oabfesrtcxbriweo")
    public suspend fun inputFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputFilter = mapped
    }

    /**
     * @param value Input settings. See Network Input Settings for more details.
     */
    @JvmName("chhnkvebgiecjlsd")
    public suspend fun networkInputSettings(`value`: ChannelInputAttachmentInputSettingsNetworkInputSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkInputSettings = mapped
    }

    /**
     * @param argument Input settings. See Network Input Settings for more details.
     */
    @JvmName("ykjwkjvwwghfaeqk")
    public suspend fun networkInputSettings(argument: suspend ChannelInputAttachmentInputSettingsNetworkInputSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsNetworkInputSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.networkInputSettings = mapped
    }

    /**
     * @param value PID from which to read SCTE-35 messages.
     */
    @JvmName("mopeycsreadkrran")
    public suspend fun scte35Pid(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Pid = mapped
    }

    /**
     * @param value Specifies whether to extract applicable ancillary data from a SMPTE-2038 source in the input.
     */
    @JvmName("dhwcrqamtlnaovni")
    public suspend fun smpte2038DataPreference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smpte2038DataPreference = mapped
    }

    /**
     * @param value Loop input if it is a file.
     */
    @JvmName("xwacgosgshbfesct")
    public suspend fun sourceEndBehavior(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEndBehavior = mapped
    }

    /**
     * @param value
     */
    @JvmName("qgvesalvmwxqgsfl")
    public suspend fun videoSelector(`value`: ChannelInputAttachmentInputSettingsVideoSelectorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoSelector = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wvnowdldjrvkvbpv")
    public suspend fun videoSelector(argument: suspend ChannelInputAttachmentInputSettingsVideoSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelInputAttachmentInputSettingsVideoSelectorArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.videoSelector = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsArgs =
        ChannelInputAttachmentInputSettingsArgs(
            audioSelectors = audioSelectors,
            captionSelectors = captionSelectors,
            deblockFilter = deblockFilter,
            denoiseFilter = denoiseFilter,
            filterStrength = filterStrength,
            inputFilter = inputFilter,
            networkInputSettings = networkInputSettings,
            scte35Pid = scte35Pid,
            smpte2038DataPreference = smpte2038DataPreference,
            sourceEndBehavior = sourceEndBehavior,
            videoSelector = videoSelector,
        )
}
