@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property languageCode
 * @property name Name of the Channel.
 * The following arguments are optional:
 * @property selectorSettings
 */
public data class ChannelInputAttachmentInputSettingsCaptionSelectorArgs(
    public val languageCode: Output<String>? = null,
    public val name: Output<String>,
    public val selectorSettings: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsCaptionSelectorArgs.builder()
            .languageCode(languageCode?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .selectorSettings(
                selectorSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsCaptionSelectorArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsCaptionSelectorArgsBuilder internal constructor() {
    private var languageCode: Output<String>? = null

    private var name: Output<String>? = null

    private var selectorSettings:
        Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>? = null

    /**
     * @param value
     */
    @JvmName("ehkvyfnohcfrxhtu")
    public suspend fun languageCode(`value`: Output<String>) {
        this.languageCode = value
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("rdlqwplonwdouqgu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value
     */
    @JvmName("ashjqiuoscqddfxx")
    public suspend fun selectorSettings(`value`: Output<ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs>) {
        this.selectorSettings = value
    }

    /**
     * @param value
     */
    @JvmName("swmbifanbevqhptm")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.languageCode = mapped
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("gwwundegixjdqubm")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value
     */
    @JvmName("gipcrmbspligekpx")
    public suspend fun selectorSettings(`value`: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectorSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("dobcqfutamjmxqec")
    public suspend fun selectorSettings(argument: suspend ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.selectorSettings = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsCaptionSelectorArgs =
        ChannelInputAttachmentInputSettingsCaptionSelectorArgs(
            languageCode = languageCode,
            name = name ?: throw PulumiNullFieldException("name"),
            selectorSettings = selectorSettings,
        )
}
