@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bandwidth The bitrate is specified in bits per second, as in an HLS manifest.
 * @property bufferSegments Buffer segments.
 * @property retries The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
 * @property retryInterval The number of seconds between retries when an attempt to read a manifest or segment fails.
 * @property scte35Source
 */
public data class ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs(
    public val bandwidth: Output<Int>? = null,
    public val bufferSegments: Output<Int>? = null,
    public val retries: Output<Int>? = null,
    public val retryInterval: Output<Int>? = null,
    public val scte35Source: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs.builder()
            .bandwidth(bandwidth?.applyValue({ args0 -> args0 }))
            .bufferSegments(bufferSegments?.applyValue({ args0 -> args0 }))
            .retries(retries?.applyValue({ args0 -> args0 }))
            .retryInterval(retryInterval?.applyValue({ args0 -> args0 }))
            .scte35Source(scte35Source?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs].
 */
@PulumiTagMarker
public class ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgsBuilder
internal constructor() {
    private var bandwidth: Output<Int>? = null

    private var bufferSegments: Output<Int>? = null

    private var retries: Output<Int>? = null

    private var retryInterval: Output<Int>? = null

    private var scte35Source: Output<String>? = null

    /**
     * @param value The bitrate is specified in bits per second, as in an HLS manifest.
     */
    @JvmName("pifhmkxmwphleihd")
    public suspend fun bandwidth(`value`: Output<Int>) {
        this.bandwidth = value
    }

    /**
     * @param value Buffer segments.
     */
    @JvmName("xlbyxmrsnysirfxh")
    public suspend fun bufferSegments(`value`: Output<Int>) {
        this.bufferSegments = value
    }

    /**
     * @param value The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
     */
    @JvmName("fsspynkyvtfeiocd")
    public suspend fun retries(`value`: Output<Int>) {
        this.retries = value
    }

    /**
     * @param value The number of seconds between retries when an attempt to read a manifest or segment fails.
     */
    @JvmName("abthusiwljiaombm")
    public suspend fun retryInterval(`value`: Output<Int>) {
        this.retryInterval = value
    }

    /**
     * @param value
     */
    @JvmName("mttkjyuutshayrlp")
    public suspend fun scte35Source(`value`: Output<String>) {
        this.scte35Source = value
    }

    /**
     * @param value The bitrate is specified in bits per second, as in an HLS manifest.
     */
    @JvmName("upiwlyynaijfuhpy")
    public suspend fun bandwidth(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bandwidth = mapped
    }

    /**
     * @param value Buffer segments.
     */
    @JvmName("xtjokouxlcfgnywp")
    public suspend fun bufferSegments(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bufferSegments = mapped
    }

    /**
     * @param value The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
     */
    @JvmName("cmbwlkiwxybwyyhv")
    public suspend fun retries(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retries = mapped
    }

    /**
     * @param value The number of seconds between retries when an attempt to read a manifest or segment fails.
     */
    @JvmName("dftaxikhkhbmjgjq")
    public suspend fun retryInterval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retryInterval = mapped
    }

    /**
     * @param value
     */
    @JvmName("hghhllccrgvvtkpc")
    public suspend fun scte35Source(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte35Source = mapped
    }

    internal fun build(): ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs = ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettingsArgs(
        bandwidth = bandwidth,
        bufferSegments = bufferSegments,
        retries = retries,
        retryInterval = retryInterval,
        scte35Source = scte35Source,
    )
}
