@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelMaintenanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maintenanceDay The day of the week to use for maintenance.
 * @property maintenanceStartTime The hour maintenance will start.
 */
public data class ChannelMaintenanceArgs(
    public val maintenanceDay: Output<String>,
    public val maintenanceStartTime: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelMaintenanceArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelMaintenanceArgs =
        com.pulumi.aws.medialive.inputs.ChannelMaintenanceArgs.builder()
            .maintenanceDay(maintenanceDay.applyValue({ args0 -> args0 }))
            .maintenanceStartTime(maintenanceStartTime.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelMaintenanceArgs].
 */
@PulumiTagMarker
public class ChannelMaintenanceArgsBuilder internal constructor() {
    private var maintenanceDay: Output<String>? = null

    private var maintenanceStartTime: Output<String>? = null

    /**
     * @param value The day of the week to use for maintenance.
     */
    @JvmName("ehmjgmurpapcjbar")
    public suspend fun maintenanceDay(`value`: Output<String>) {
        this.maintenanceDay = value
    }

    /**
     * @param value The hour maintenance will start.
     */
    @JvmName("bqaqsxxmdrwhrnie")
    public suspend fun maintenanceStartTime(`value`: Output<String>) {
        this.maintenanceStartTime = value
    }

    /**
     * @param value The day of the week to use for maintenance.
     */
    @JvmName("qernmyixksnipufn")
    public suspend fun maintenanceDay(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceDay = mapped
    }

    /**
     * @param value The hour maintenance will start.
     */
    @JvmName("dkuwutlqsovgwkau")
    public suspend fun maintenanceStartTime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maintenanceStartTime = mapped
    }

    internal fun build(): ChannelMaintenanceArgs = ChannelMaintenanceArgs(
        maintenanceDay = maintenanceDay ?: throw PulumiNullFieldException("maintenanceDay"),
        maintenanceStartTime = maintenanceStartTime ?: throw
            PulumiNullFieldException("maintenanceStartTime"),
    )
}
