@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.GetInputPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInput.
 * @property id The ID of the Input.
 */
public data class GetInputPlainArgs(
    public val id: String,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.GetInputPlainArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.GetInputPlainArgs =
        com.pulumi.aws.medialive.inputs.GetInputPlainArgs.builder()
            .id(id.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInputPlainArgs].
 */
@PulumiTagMarker
public class GetInputPlainArgsBuilder internal constructor() {
    private var id: String? = null

    /**
     * @param value The ID of the Input.
     */
    @JvmName("vrnwyikiueuhjutb")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    internal fun build(): GetInputPlainArgs = GetInputPlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
