@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputInputDeviceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id The unique ID for the device.
 */
public data class InputInputDeviceArgs(
    public val id: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputInputDeviceArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputInputDeviceArgs =
        com.pulumi.aws.medialive.inputs.InputInputDeviceArgs.builder()
            .id(id.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputInputDeviceArgs].
 */
@PulumiTagMarker
public class InputInputDeviceArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The unique ID for the device.
     */
    @JvmName("qobkljkvjeuocrjy")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The unique ID for the device.
     */
    @JvmName("rcapjigworhxdopi")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): InputInputDeviceArgs = InputInputDeviceArgs(
        id = id ?: throw PulumiNullFieldException("id"),
    )
}
