@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cidr The IPv4 CIDR that's whitelisted.
 */
public data class InputSecurityGroupWhitelistRuleArgs(
    public val cidr: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs =
        com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs.builder()
            .cidr(cidr.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InputSecurityGroupWhitelistRuleArgs].
 */
@PulumiTagMarker
public class InputSecurityGroupWhitelistRuleArgsBuilder internal constructor() {
    private var cidr: Output<String>? = null

    /**
     * @param value The IPv4 CIDR that's whitelisted.
     */
    @JvmName("jvmlkjttorssbgcd")
    public suspend fun cidr(`value`: Output<String>) {
        this.cidr = value
    }

    /**
     * @param value The IPv4 CIDR that's whitelisted.
     */
    @JvmName("henwcqwpfsamdgky")
    public suspend fun cidr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cidr = mapped
    }

    internal fun build(): InputSecurityGroupWhitelistRuleArgs = InputSecurityGroupWhitelistRuleArgs(
        cidr = cidr ?: throw PulumiNullFieldException("cidr"),
    )
}
