@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.InputVpcArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds A list of up to 5 EC2 VPC security group IDs to attach to the Input.
 * @property subnetIds A list of 2 VPC subnet IDs from the same VPC.
 */
public data class InputVpcArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.InputVpcArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.InputVpcArgs =
        com.pulumi.aws.medialive.inputs.InputVpcArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [InputVpcArgs].
 */
@PulumiTagMarker
public class InputVpcArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value A list of up to 5 EC2 VPC security group IDs to attach to the Input.
     */
    @JvmName("kaaphrgwditovtbw")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("seafcsvtlexswqtb")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of up to 5 EC2 VPC security group IDs to attach to the Input.
     */
    @JvmName("wimxfbbsixllmrou")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of 2 VPC subnet IDs from the same VPC.
     */
    @JvmName("dvgyvhuotnxanggd")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("hpveobogmlqbjaaq")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of 2 VPC subnet IDs from the same VPC.
     */
    @JvmName("mlihtfqnjfjnxxdn")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value A list of up to 5 EC2 VPC security group IDs to attach to the Input.
     */
    @JvmName("vhtnncxyxhltflea")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of up to 5 EC2 VPC security group IDs to attach to the Input.
     */
    @JvmName("fjhqgeeycfcftroq")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of 2 VPC subnet IDs from the same VPC.
     */
    @JvmName("fxkncixluytnaxrw")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of 2 VPC subnet IDs from the same VPC.
     */
    @JvmName("hsqbimyyerxuumsw")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): InputVpcArgs = InputVpcArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
    )
}
