@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property preferredChannelPipeline Enum for preferred channel pipeline. Options are `CURRENTLY_ACTIVE`, `PIPELINE_0`, or `PIPELINE_1`.
 * @property programNumber Unique program number.
 * @property serviceDescriptor Service Descriptor. See Service Descriptor for more details.
 * @property videoSettings Video settings. See Video Settings for more details.
 */
public data class MultiplexProgramMultiplexProgramSettingsArgs(
    public val preferredChannelPipeline: Output<String>,
    public val programNumber: Output<Int>,
    public val serviceDescriptor: Output<MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs>? = null,
    public val videoSettings: Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs =
        com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs.builder()
            .preferredChannelPipeline(preferredChannelPipeline.applyValue({ args0 -> args0 }))
            .programNumber(programNumber.applyValue({ args0 -> args0 }))
            .serviceDescriptor(serviceDescriptor?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoSettings(videoSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MultiplexProgramMultiplexProgramSettingsArgs].
 */
@PulumiTagMarker
public class MultiplexProgramMultiplexProgramSettingsArgsBuilder internal constructor() {
    private var preferredChannelPipeline: Output<String>? = null

    private var programNumber: Output<Int>? = null

    private var serviceDescriptor:
        Output<MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs>? = null

    private var videoSettings: Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs>? =
        null

    /**
     * @param value Enum for preferred channel pipeline. Options are `CURRENTLY_ACTIVE`, `PIPELINE_0`, or `PIPELINE_1`.
     */
    @JvmName("dyyojbxthfthhnnh")
    public suspend fun preferredChannelPipeline(`value`: Output<String>) {
        this.preferredChannelPipeline = value
    }

    /**
     * @param value Unique program number.
     */
    @JvmName("dyduutmdxsbpbctj")
    public suspend fun programNumber(`value`: Output<Int>) {
        this.programNumber = value
    }

    /**
     * @param value Service Descriptor. See Service Descriptor for more details.
     */
    @JvmName("tksfwxhiqjpvlgic")
    public suspend fun serviceDescriptor(`value`: Output<MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs>) {
        this.serviceDescriptor = value
    }

    /**
     * @param value Video settings. See Video Settings for more details.
     */
    @JvmName("lxxabjynoiqolhhp")
    public suspend fun videoSettings(`value`: Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs>) {
        this.videoSettings = value
    }

    /**
     * @param value Enum for preferred channel pipeline. Options are `CURRENTLY_ACTIVE`, `PIPELINE_0`, or `PIPELINE_1`.
     */
    @JvmName("jituthpygedcwdqr")
    public suspend fun preferredChannelPipeline(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.preferredChannelPipeline = mapped
    }

    /**
     * @param value Unique program number.
     */
    @JvmName("psedhjuwfpxnevhe")
    public suspend fun programNumber(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.programNumber = mapped
    }

    /**
     * @param value Service Descriptor. See Service Descriptor for more details.
     */
    @JvmName("mgqnkdhrenduuehj")
    public suspend fun serviceDescriptor(`value`: MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDescriptor = mapped
    }

    /**
     * @param argument Service Descriptor. See Service Descriptor for more details.
     */
    @JvmName("yhkpqgpybhpohwic")
    public suspend fun serviceDescriptor(argument: suspend MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgsBuilder.() -> Unit) {
        val toBeMapped =
            MultiplexProgramMultiplexProgramSettingsServiceDescriptorArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.serviceDescriptor = mapped
    }

    /**
     * @param value Video settings. See Video Settings for more details.
     */
    @JvmName("xokeitblawcpmbqu")
    public suspend fun videoSettings(`value`: MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoSettings = mapped
    }

    /**
     * @param argument Video settings. See Video Settings for more details.
     */
    @JvmName("rkfpmwxnsojisbjm")
    public suspend fun videoSettings(argument: suspend MultiplexProgramMultiplexProgramSettingsVideoSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            MultiplexProgramMultiplexProgramSettingsVideoSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.videoSettings = mapped
    }

    internal fun build(): MultiplexProgramMultiplexProgramSettingsArgs =
        MultiplexProgramMultiplexProgramSettingsArgs(
            preferredChannelPipeline = preferredChannelPipeline ?: throw
                PulumiNullFieldException("preferredChannelPipeline"),
            programNumber = programNumber ?: throw PulumiNullFieldException("programNumber"),
            serviceDescriptor = serviceDescriptor,
            videoSettings = videoSettings,
        )
}
