@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property constantBitrate Constant bitrate value.
 * @property statmuxSettings Statmux settings. See Statmux Settings for more details.
 */
public data class MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs(
    public val constantBitrate: Output<Int>? = null,
    public val statmuxSettings: Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs =
        com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs.builder()
            .constantBitrate(constantBitrate?.applyValue({ args0 -> args0 }))
            .statmuxSettings(
                statmuxSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs].
 */
@PulumiTagMarker
public class MultiplexProgramMultiplexProgramSettingsVideoSettingsArgsBuilder internal constructor() {
    private var constantBitrate: Output<Int>? = null

    private var statmuxSettings:
        Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs>? = null

    /**
     * @param value Constant bitrate value.
     */
    @JvmName("fksnmaktrbcopvoq")
    public suspend fun constantBitrate(`value`: Output<Int>) {
        this.constantBitrate = value
    }

    /**
     * @param value Statmux settings. See Statmux Settings for more details.
     */
    @JvmName("efeaacchpqpavebc")
    public suspend fun statmuxSettings(`value`: Output<MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs>) {
        this.statmuxSettings = value
    }

    /**
     * @param value Constant bitrate value.
     */
    @JvmName("gevbhixnmjiyjkxh")
    public suspend fun constantBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.constantBitrate = mapped
    }

    /**
     * @param value Statmux settings. See Statmux Settings for more details.
     */
    @JvmName("qbuvqvpgmuhhmbyk")
    public suspend fun statmuxSettings(`value`: MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statmuxSettings = mapped
    }

    /**
     * @param argument Statmux settings. See Statmux Settings for more details.
     */
    @JvmName("jwafyqqhhdveirvw")
    public suspend fun statmuxSettings(argument: suspend MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.statmuxSettings = mapped
    }

    internal fun build(): MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs =
        MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs(
            constantBitrate = constantBitrate,
            statmuxSettings = statmuxSettings,
        )
}
