@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maximumBitrate Maximum bitrate.
 * @property minimumBitrate Minimum bitrate.
 * @property priority Priority value.
 */
public data class MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs(
    public val maximumBitrate: Output<Int>? = null,
    public val minimumBitrate: Output<Int>? = null,
    public val priority: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs =
        com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs.builder()
            .maximumBitrate(maximumBitrate?.applyValue({ args0 -> args0 }))
            .minimumBitrate(minimumBitrate?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs].
 */
@PulumiTagMarker
public class MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgsBuilder
internal constructor() {
    private var maximumBitrate: Output<Int>? = null

    private var minimumBitrate: Output<Int>? = null

    private var priority: Output<Int>? = null

    /**
     * @param value Maximum bitrate.
     */
    @JvmName("ioqbswpktrxbpthl")
    public suspend fun maximumBitrate(`value`: Output<Int>) {
        this.maximumBitrate = value
    }

    /**
     * @param value Minimum bitrate.
     */
    @JvmName("sidtvscxffdaetoj")
    public suspend fun minimumBitrate(`value`: Output<Int>) {
        this.minimumBitrate = value
    }

    /**
     * @param value Priority value.
     */
    @JvmName("oritybflwnhybvuf")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Maximum bitrate.
     */
    @JvmName("tykjmxayjqxsjqpq")
    public suspend fun maximumBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumBitrate = mapped
    }

    /**
     * @param value Minimum bitrate.
     */
    @JvmName("lfxdebomdwmkftmg")
    public suspend fun minimumBitrate(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimumBitrate = mapped
    }

    /**
     * @param value Priority value.
     */
    @JvmName("kdemajnnouleokkv")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    internal fun build(): MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs =
        MultiplexProgramMultiplexProgramSettingsVideoSettingsStatmuxSettingsArgs(
            maximumBitrate = maximumBitrate,
            minimumBitrate = minimumBitrate,
            priority = priority,
        )
}
