@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property multiplexId The ID of the Multiplex that the encoder is providing output to.
 * @property programName The program name of the Multiplex program that the encoder is providing output to.
 */
public data class ChannelDestinationMultiplexSettings(
    public val multiplexId: String,
    public val programName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelDestinationMultiplexSettings): ChannelDestinationMultiplexSettings = ChannelDestinationMultiplexSettings(
            multiplexId = javaType.multiplexId(),
            programName = javaType.programName(),
        )
    }
}
