@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property passwordParam Key used to extract the password from EC2 Parameter store.
 * @property streamName Stream name RTMP destinations (URLs of type rtmp://)
 * @property url A URL specifying a destination.
 * @property username Username for destination.
 */
public data class ChannelDestinationSetting(
    public val passwordParam: String? = null,
    public val streamName: String? = null,
    public val url: String? = null,
    public val username: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelDestinationSetting): ChannelDestinationSetting = ChannelDestinationSetting(
            passwordParam = javaType.passwordParam().map({ args0 -> args0 }).orElse(null),
            streamName = javaType.streamName().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
            username = javaType.username().map({ args0 -> args0 }).orElse(null),
        )
    }
}
