@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property audioDescriptions Audio descriptions for the channel. See Audio Descriptions for more details.
 * @property availBlanking Settings for ad avail blanking. See Avail Blanking for more details.
 * @property captionDescriptions Caption Descriptions. See Caption Descriptions for more details.
 * @property globalConfiguration Configuration settings that apply to the event as a whole. See Global Configuration for more details.
 * @property motionGraphicsConfiguration Settings for motion graphics. See Motion Graphics Configuration for more details.
 * @property nielsenConfiguration Nielsen configuration settings. See Nielsen Configuration for more details.
 * @property outputGroups Output groups for the channel. See Output Groups for more details.
 * @property timecodeConfig Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
 * @property videoDescriptions Video Descriptions. See Video Descriptions for more details.
 */
public data class ChannelEncoderSettings(
    public val audioDescriptions: List<ChannelEncoderSettingsAudioDescription>? = null,
    public val availBlanking: ChannelEncoderSettingsAvailBlanking? = null,
    public val captionDescriptions: List<ChannelEncoderSettingsCaptionDescription>? = null,
    public val globalConfiguration: ChannelEncoderSettingsGlobalConfiguration? = null,
    public val motionGraphicsConfiguration: ChannelEncoderSettingsMotionGraphicsConfiguration? = null,
    public val nielsenConfiguration: ChannelEncoderSettingsNielsenConfiguration? = null,
    public val outputGroups: List<ChannelEncoderSettingsOutputGroup>,
    public val timecodeConfig: ChannelEncoderSettingsTimecodeConfig,
    public val videoDescriptions: List<ChannelEncoderSettingsVideoDescription>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettings): ChannelEncoderSettings = ChannelEncoderSettings(
            audioDescriptions = javaType.audioDescriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAudioDescription.Companion.toKotlin(args0)
                })
            }),
            availBlanking = javaType.availBlanking().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsAvailBlanking.Companion.toKotlin(args0)
                })
            }).orElse(null),
            captionDescriptions = javaType.captionDescriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescription.Companion.toKotlin(args0)
                })
            }),
            globalConfiguration = javaType.globalConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsGlobalConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            motionGraphicsConfiguration = javaType.motionGraphicsConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsMotionGraphicsConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nielsenConfiguration = javaType.nielsenConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsNielsenConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outputGroups = javaType.outputGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroup.Companion.toKotlin(args0)
                })
            }),
            timecodeConfig = javaType.timecodeConfig().let({ args0 ->
                com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsTimecodeConfig.Companion.toKotlin(args0)
            }),
            videoDescriptions = javaType.videoDescriptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescription.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
