@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property inputType Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD (narration) as a stereo pair.
 * @property profile AAC profile.
 * @property rateControlMode The rate control mode.
 * @property rawFormat Sets LATM/LOAS AAC output for raw containers.
 * @property sampleRate Sample rate in Hz.
 * @property spec Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport Stream containers.
 * @property vbrQuality VBR Quality Level - Only used if rateControlMode is VBR.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings(
    public val bitrate: Double? = null,
    public val codingMode: String? = null,
    public val inputType: String? = null,
    public val profile: String? = null,
    public val rateControlMode: String? = null,
    public val rawFormat: String? = null,
    public val sampleRate: Double? = null,
    public val spec: String? = null,
    public val vbrQuality: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings): ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettings(
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                codingMode = javaType.codingMode().map({ args0 -> args0 }).orElse(null),
                inputType = javaType.inputType().map({ args0 -> args0 }).orElse(null),
                profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
                rateControlMode = javaType.rateControlMode().map({ args0 -> args0 }).orElse(null),
                rawFormat = javaType.rawFormat().map({ args0 -> args0 }).orElse(null),
                sampleRate = javaType.sampleRate().map({ args0 -> args0 }).orElse(null),
                spec = javaType.spec().map({ args0 -> args0 }).orElse(null),
                vbrQuality = javaType.vbrQuality().map({ args0 -> args0 }).orElse(null),
            )
    }
}
