@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property codingMode Dolby Digital Plus with Dolby Atmos coding mode.
 * @property dialnorm Sets the dialnorm for the output.
 * @property drcLine Sets the Dolby dynamic range compression profile.
 * @property drcRf Sets the profile for heavy Dolby dynamic range compression.
 * @property heightTrim Height dimensional trim.
 * @property surroundTrim Surround dimensional trim.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings(
    public val bitrate: Double? = null,
    public val codingMode: String? = null,
    public val dialnorm: Double? = null,
    public val drcLine: String? = null,
    public val drcRf: String? = null,
    public val heightTrim: Double? = null,
    public val surroundTrim: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings): ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettings(
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                codingMode = javaType.codingMode().map({ args0 -> args0 }).orElse(null),
                dialnorm = javaType.dialnorm().map({ args0 -> args0 }).orElse(null),
                drcLine = javaType.drcLine().map({ args0 -> args0 }).orElse(null),
                drcRf = javaType.drcRf().map({ args0 -> args0 }).orElse(null),
                heightTrim = javaType.heightTrim().map({ args0 -> args0 }).orElse(null),
                surroundTrim = javaType.surroundTrim().map({ args0 -> args0 }).orElse(null),
            )
    }
}
