@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property attenuationControl Sets the attenuation control.
 * @property bitrate Average bitrate in bits/second.
 * @property bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
 * @property codingMode Dolby Digital Plus coding mode.
 * @property dcFilter
 * @property dialnorm
 * @property drcLine Sets the Dolby dynamic range compression profile.
 * @property drcRf Sets the profile for heavy Dolby dynamic range compression.
 * @property lfeControl
 * @property lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
 * @property loRoCenterMixLevel
 * @property loRoSurroundMixLevel
 * @property ltRtCenterMixLevel
 * @property ltRtSurroundMixLevel
 * @property metadataControl Metadata control.
 * @property passthroughControl
 * @property phaseControl
 * @property stereoDownmix
 * @property surroundExMode
 * @property surroundMode
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings(
    public val attenuationControl: String? = null,
    public val bitrate: Double? = null,
    public val bitstreamMode: String? = null,
    public val codingMode: String? = null,
    public val dcFilter: String? = null,
    public val dialnorm: Int? = null,
    public val drcLine: String? = null,
    public val drcRf: String? = null,
    public val lfeControl: String? = null,
    public val lfeFilter: String? = null,
    public val loRoCenterMixLevel: Double? = null,
    public val loRoSurroundMixLevel: Double? = null,
    public val ltRtCenterMixLevel: Double? = null,
    public val ltRtSurroundMixLevel: Double? = null,
    public val metadataControl: String? = null,
    public val passthroughControl: String? = null,
    public val phaseControl: String? = null,
    public val stereoDownmix: String? = null,
    public val surroundExMode: String? = null,
    public val surroundMode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings): ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3Settings(
                attenuationControl = javaType.attenuationControl().map({ args0 -> args0 }).orElse(null),
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                bitstreamMode = javaType.bitstreamMode().map({ args0 -> args0 }).orElse(null),
                codingMode = javaType.codingMode().map({ args0 -> args0 }).orElse(null),
                dcFilter = javaType.dcFilter().map({ args0 -> args0 }).orElse(null),
                dialnorm = javaType.dialnorm().map({ args0 -> args0 }).orElse(null),
                drcLine = javaType.drcLine().map({ args0 -> args0 }).orElse(null),
                drcRf = javaType.drcRf().map({ args0 -> args0 }).orElse(null),
                lfeControl = javaType.lfeControl().map({ args0 -> args0 }).orElse(null),
                lfeFilter = javaType.lfeFilter().map({ args0 -> args0 }).orElse(null),
                loRoCenterMixLevel = javaType.loRoCenterMixLevel().map({ args0 -> args0 }).orElse(null),
                loRoSurroundMixLevel = javaType.loRoSurroundMixLevel().map({ args0 -> args0 }).orElse(null),
                ltRtCenterMixLevel = javaType.ltRtCenterMixLevel().map({ args0 -> args0 }).orElse(null),
                ltRtSurroundMixLevel = javaType.ltRtSurroundMixLevel().map({ args0 -> args0 }).orElse(null),
                metadataControl = javaType.metadataControl().map({ args0 -> args0 }).orElse(null),
                passthroughControl = javaType.passthroughControl().map({ args0 -> args0 }).orElse(null),
                phaseControl = javaType.phaseControl().map({ args0 -> args0 }).orElse(null),
                stereoDownmix = javaType.stereoDownmix().map({ args0 -> args0 }).orElse(null),
                surroundExMode = javaType.surroundExMode().map({ args0 -> args0 }).orElse(null),
                surroundMode = javaType.surroundMode().map({ args0 -> args0 }).orElse(null),
            )
    }
}
