@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property aribDestinationSettings ARIB Destination Settings.
 * @property burnInDestinationSettings Burn In Destination Settings. See Burn In Destination Settings for more details.
 * @property dvbSubDestinationSettings DVB Sub Destination Settings. See DVB Sub Destination Settings for more details.
 * @property ebuTtDDestinationSettings EBU TT D Destination Settings. See EBU TT D Destination Settings for more details.
 * @property embeddedDestinationSettings Embedded Destination Settings.
 * @property embeddedPlusScte20DestinationSettings Embedded Plus SCTE20 Destination Settings.
 * @property rtmpCaptionInfoDestinationSettings RTMP Caption Info Destination Settings.
 * @property scte20PlusEmbeddedDestinationSettings SCTE20 Plus Embedded Destination Settings.
 * @property scte27DestinationSettings SCTE27 Destination Settings.
 * @property smpteTtDestinationSettings SMPTE TT Destination Settings.
 * @property teletextDestinationSettings Teletext Destination Settings.
 * @property ttmlDestinationSettings TTML Destination Settings. See TTML Destination Settings for more details.
 * @property webvttDestinationSettings WebVTT Destination Settings. See WebVTT Destination Settings for more details.
 */
public data class ChannelEncoderSettingsCaptionDescriptionDestinationSettings(
    public val aribDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettings? = null,
    public val burnInDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings? = null,
    public val dvbSubDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettings? = null,
    public val ebuTtDDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings? = null,
    public val embeddedDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettings? =
        null,
    public val embeddedPlusScte20DestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettings? =
        null,
    public val rtmpCaptionInfoDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettings? =
        null,
    public val scte20PlusEmbeddedDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettings? =
        null,
    public val scte27DestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettings? = null,
    public val smpteTtDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettings? = null,
    public val teletextDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettings? =
        null,
    public val ttmlDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettings? = null,
    public val webvttDestinationSettings: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettings): ChannelEncoderSettingsCaptionDescriptionDestinationSettings =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettings(
                aribDestinationSettings = javaType.aribDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                burnInDestinationSettings = javaType.burnInDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dvbSubDestinationSettings = javaType.dvbSubDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ebuTtDDestinationSettings = javaType.ebuTtDDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                embeddedDestinationSettings = javaType.embeddedDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                embeddedPlusScte20DestinationSettings = javaType.embeddedPlusScte20DestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rtmpCaptionInfoDestinationSettings = javaType.rtmpCaptionInfoDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scte20PlusEmbeddedDestinationSettings = javaType.scte20PlusEmbeddedDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scte27DestinationSettings = javaType.scte27DestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                smpteTtDestinationSettings = javaType.smpteTtDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                teletextDestinationSettings = javaType.teletextDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                ttmlDestinationSettings = javaType.ttmlDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                webvttDestinationSettings = javaType.webvttDestinationSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
