@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property alignment If no explicit xPosition or yPosition is provided, setting alignment to centered will place the captions at the bottom center of the output. Similarly, setting a left alignment will align captions to the bottom left of the output. If x and y positions are given in conjunction with the alignment parameter, the font will be justified (either left or centered) relative to those coordinates. Selecting “smart” justification will left-justify live subtitles and center-justify pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
 * @property backgroundColor Specifies the color of the rectangle behind the captions. All burn-in and DVB-Sub font settings must match.
 * @property backgroundOpacity Specifies the opacity of the background rectangle. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
 * @property font External font file used for caption burn-in. File extension must be ‘ttf’ or ‘tte’. Although the user can select output fonts for many different types of input captions, embedded, STL and teletext sources use a strict grid system. Using external fonts with these caption sources could cause unexpected display of proportional fonts. All burn-in and DVB-Sub font settings must match. See Font for more details.
 * @property fontColor Specifies the color of the burned-in captions. This option is not valid for source captions that are STL, 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property fontOpacity Specifies the opacity of the burned-in captions. 255 is opaque; 0 is transparent. All burn-in and DVB-Sub font settings must match.
 * @property fontResolution Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and DVB-Sub font settings must match.
 * @property fontSize When set to ‘auto’ fontSize will scale depending on the size of the output. Giving a positive integer will specify the exact font size in points. All burn-in and DVB-Sub font settings must match.
 * @property outlineColor Specifies font outline color. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property outlineSize Specifies font outline size in pixels. This option is not valid for source captions that are either 608/embedded or teletext. These source settings are already pre-defined by the caption stream. All burn-in and DVB-Sub font settings must match.
 * @property shadowColor Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub font settings must match.
 * @property shadowOpacity Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving this parameter out is equivalent to setting it to 0 (transparent). All burn-in and DVB-Sub font settings must match.
 * @property shadowXOffset Specifies the horizontal offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All burn-in and DVB-Sub font settings must match.
 * @property shadowYOffset Specifies the vertical offset of the shadow relative to the captions in pixels. A value of -2 would result in a shadow offset 2 pixels above the text. All burn-in and DVB-Sub font settings must match.
 * @property teletextGridControl Controls whether a fixed grid size will be used to generate the output subtitles bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
 * @property xPosition Specifies the horizontal position of the caption relative to the left side of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the left of the output. If no explicit xPosition is provided, the horizontal caption position will be determined by the alignment parameter. All burn-in and DVB-Sub font settings must match.
 * @property yPosition Specifies the vertical position of the caption relative to the top of the output in pixels. A value of 10 would result in the captions starting 10 pixels from the top of the output. If no explicit yPosition is provided, the caption will be positioned towards the bottom of the output. All burn-in and DVB-Sub font settings must match.
 */
public data class
ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings(
    public val alignment: String? = null,
    public val backgroundColor: String? = null,
    public val backgroundOpacity: Int? = null,
    public val font: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFont? =
        null,
    public val fontColor: String? = null,
    public val fontOpacity: Int? = null,
    public val fontResolution: Int? = null,
    public val fontSize: String? = null,
    public val outlineColor: String,
    public val outlineSize: Int? = null,
    public val shadowColor: String? = null,
    public val shadowOpacity: Int? = null,
    public val shadowXOffset: Int? = null,
    public val shadowYOffset: Int? = null,
    public val teletextGridControl: String,
    public val xPosition: Int? = null,
    public val yPosition: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings): ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettings(
                alignment = javaType.alignment().map({ args0 -> args0 }).orElse(null),
                backgroundColor = javaType.backgroundColor().map({ args0 -> args0 }).orElse(null),
                backgroundOpacity = javaType.backgroundOpacity().map({ args0 -> args0 }).orElse(null),
                font = javaType.font().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsFont.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fontColor = javaType.fontColor().map({ args0 -> args0 }).orElse(null),
                fontOpacity = javaType.fontOpacity().map({ args0 -> args0 }).orElse(null),
                fontResolution = javaType.fontResolution().map({ args0 -> args0 }).orElse(null),
                fontSize = javaType.fontSize().map({ args0 -> args0 }).orElse(null),
                outlineColor = javaType.outlineColor(),
                outlineSize = javaType.outlineSize().map({ args0 -> args0 }).orElse(null),
                shadowColor = javaType.shadowColor().map({ args0 -> args0 }).orElse(null),
                shadowOpacity = javaType.shadowOpacity().map({ args0 -> args0 }).orElse(null),
                shadowXOffset = javaType.shadowXOffset().map({ args0 -> args0 }).orElse(null),
                shadowYOffset = javaType.shadowYOffset().map({ args0 -> args0 }).orElse(null),
                teletextGridControl = javaType.teletextGridControl(),
                xPosition = javaType.xPosition().map({ args0 -> args0 }).orElse(null),
                yPosition = javaType.yPosition().map({ args0 -> args0 }).orElse(null),
            )
    }
}
