@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property initialAudioGain Value to set the initial audio gain for the Live Event.
 * @property inputEndAction Indicates the action to take when the current input completes (e.g. end-of-file). When switchAndLoopInputs is configured the encoder will restart at the beginning of the first input. When “none” is configured the encoder will transcode either black, a solid color, or a user specified slate images per the “Input Loss Behavior” configuration until the next input switch occurs (which is controlled through the Channel Schedule API).
 * @property inputLossBehavior Settings for system actions when input is lost. See Input Loss Behavior for more details.
 * @property outputLockingMode Indicates how MediaLive pipelines are synchronized. PIPELINE\_LOCKING - MediaLive will attempt to synchronize the output of each pipeline to the other. EPOCH\_LOCKING - MediaLive will attempt to synchronize the output of each pipeline to the Unix epoch.
 * @property outputTimingSource Indicates whether the rate of frames emitted by the Live encoder should be paced by its system clock (which optionally may be locked to another source via NTP) or should be locked to the clock of the source that is providing the input stream.
 * @property supportLowFramerateInputs Adjusts video input buffer for streams with very low video framerates. This is commonly set to enabled for music channels with less than one video frame per second.
 */
public data class ChannelEncoderSettingsGlobalConfiguration(
    public val initialAudioGain: Int? = null,
    public val inputEndAction: String? = null,
    public val inputLossBehavior: ChannelEncoderSettingsGlobalConfigurationInputLossBehavior? = null,
    public val outputLockingMode: String? = null,
    public val outputTimingSource: String? = null,
    public val supportLowFramerateInputs: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsGlobalConfiguration): ChannelEncoderSettingsGlobalConfiguration = ChannelEncoderSettingsGlobalConfiguration(
            initialAudioGain = javaType.initialAudioGain().map({ args0 -> args0 }).orElse(null),
            inputEndAction = javaType.inputEndAction().map({ args0 -> args0 }).orElse(null),
            inputLossBehavior = javaType.inputLossBehavior().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsGlobalConfigurationInputLossBehavior.Companion.toKotlin(args0)
                })
            }).orElse(null),
            outputLockingMode = javaType.outputLockingMode().map({ args0 -> args0 }).orElse(null),
            outputTimingSource = javaType.outputTimingSource().map({ args0 -> args0 }).orElse(null),
            supportLowFramerateInputs = javaType.supportLowFramerateInputs().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
