@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property distributorId Enter the Distributor ID assigned to your organization by Nielsen.
 * @property nielsenPcmToId3Tagging Enables Nielsen PCM to ID3 tagging.
 */
public data class ChannelEncoderSettingsNielsenConfiguration(
    public val distributorId: String? = null,
    public val nielsenPcmToId3Tagging: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsNielsenConfiguration): ChannelEncoderSettingsNielsenConfiguration = ChannelEncoderSettingsNielsenConfiguration(
            distributorId = javaType.distributorId().map({ args0 -> args0 }).orElse(null),
            nielsenPcmToId3Tagging = javaType.nielsenPcmToId3Tagging().map({ args0 -> args0 }).orElse(null),
        )
    }
}
