@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property archiveCdnSettings Parameters that control the interactions with the CDN. See Archive CDN Settings for more details.
 * @property destination A director and base filename where archive files should be written. See Destination for more details.
 * @property rolloverInterval Number of seconds to write to archive file before closing and starting a new one.
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting(
    public val archiveCdnSettings: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettings? =
        null,
    public val destination: ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestination,
    public val rolloverInterval: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting): ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSetting(
                archiveCdnSettings = javaType.archiveCdnSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArchiveCdnSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                destination = javaType.destination().let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestination.Companion.toKotlin(args0)
                }),
                rolloverInterval = javaType.rolloverInterval().map({ args0 -> args0 }).orElse(null),
            )
    }
}
