@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property adMarkers The ad marker type for this output group.
 * @property authenticationScheme Authentication scheme to use when connecting with CDN.
 * @property cacheFullBehavior Controls behavior when content cache fills up.
 * @property cacheLength Cache length in seconds, is used to calculate buffer size.
 * @property captionData Controls the types of data that passes to onCaptionInfo outputs.
 * @property inputLossAction Controls the behavior of the RTMP group if input becomes unavailable.
 * @property restartDelay Number of seconds to wait until a restart is initiated.
 */
public data class ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings(
    public val adMarkers: List<String>? = null,
    public val authenticationScheme: String? = null,
    public val cacheFullBehavior: String? = null,
    public val cacheLength: Int? = null,
    public val captionData: String? = null,
    public val inputLossAction: String? = null,
    public val restartDelay: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings): ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings =
            ChannelEncoderSettingsOutputGroupOutputGroupSettingsRtmpGroupSettings(
                adMarkers = javaType.adMarkers().map({ args0 -> args0 }),
                authenticationScheme = javaType.authenticationScheme().map({ args0 -> args0 }).orElse(null),
                cacheFullBehavior = javaType.cacheFullBehavior().map({ args0 -> args0 }).orElse(null),
                cacheLength = javaType.cacheLength().map({ args0 -> args0 }).orElse(null),
                captionData = javaType.captionData().map({ args0 -> args0 }).orElse(null),
                inputLossAction = javaType.inputLossAction().map({ args0 -> args0 }).orElse(null),
                restartDelay = javaType.restartDelay().map({ args0 -> args0 }).orElse(null),
            )
    }
}
