@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificateMode Setting to allow self signed or verified RTMP certificates.
 * @property connectionRetryInterval Number of seconds to wait before retrying connection to the flash media server if the connection is lost.
 * @property destination The RTMP endpoint excluding the stream name. See Destination for more details.
 * @property numRetries Number of retry attempts.
 */
public data class ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings(
    public val certificateMode: String? = null,
    public val connectionRetryInterval: Int? = null,
    public val destination: ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestination,
    public val numRetries: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings): ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings =
            ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettings(
                certificateMode = javaType.certificateMode().map({ args0 -> args0 }).orElse(null),
                connectionRetryInterval = javaType.connectionRetryInterval().map({ args0 -> args0 }).orElse(null),
                destination = javaType.destination().let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsOutputGroupOutputOutputSettingsRtmpOutputSettingsDestination.Companion.toKotlin(args0)
                }),
                numRetries = javaType.numRetries().map({ args0 -> args0 }).orElse(null),
            )
    }
}
