@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property source The source for the timecode that will be associated with the events outputs.
 * @property syncThreshold Threshold in frames beyond which output timecode is resynchronized to the input timecode.
 */
public data class ChannelEncoderSettingsTimecodeConfig(
    public val source: String,
    public val syncThreshold: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsTimecodeConfig): ChannelEncoderSettingsTimecodeConfig = ChannelEncoderSettingsTimecodeConfig(
            source = javaType.source(),
            syncThreshold = javaType.syncThreshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
