@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property adaptiveQuantization Enables or disables adaptive quantization.
 * @property afdSignaling Indicates that AFD values will be written into the output stream.
 * @property bitrate Average bitrate in bits/second.
 * @property bufFillPct
 * @property bufSize Size of buffer in bits.
 * @property colorMetadata Includes color space metadata in the output.
 * @property entropyEncoding Entropy encoding mode.
 * @property filterSettings Filters to apply to an encode. See H264 Filter Settings for more details.
 * @property fixedAfd Four bit AFD value to write on all frames of video in the output stream.
 * @property flickerAq
 * @property forceFieldPictures Controls whether coding is performed on a field basis or on a frame basis.
 * @property framerateControl Indicates how the output video frame rate is specified.
 * @property framerateDenominator Framerate denominator.
 * @property framerateNumerator Framerate numerator.
 * @property gopBReference GOP-B reference.
 * @property gopClosedCadence Frequency of closed GOPs.
 * @property gopNumBFrames Number of B-frames between reference frames.
 * @property gopSize GOP size in units of either frames of seconds per `gop_size_units`.
 * @property gopSizeUnits Indicates if the `gop_size` is specified in frames or seconds.
 * @property level H264 level.
 * @property lookAheadRateControl Amount of lookahead.
 * @property maxBitrate Set the maximum bitrate in order to accommodate expected spikes in the complexity of the video.
 * @property minIInterval
 * @property numRefFrames Number of reference frames to use.
 * @property parControl Indicates how the output pixel aspect ratio is specified.
 * @property parDenominator Pixel Aspect Ratio denominator.
 * @property parNumerator Pixel Aspect Ratio numerator.
 * @property profile H264 profile.
 * @property qualityLevel Quality level.
 * @property qvbrQualityLevel Controls the target quality for the video encode.
 * @property rateControlMode Rate control mode.
 * @property scanType Sets the scan type of the output.
 * @property sceneChangeDetect Scene change detection.
 * @property slices Number of slices per picture.
 * @property softness Softness.
 * @property spatialAq Makes adjustments within each frame based on spatial variation of content complexity.
 * @property subgopLength Subgop length.
 * @property syntax Produces a bitstream compliant with SMPTE RP-2027.
 * @property temporalAq Makes adjustments within each frame based on temporal variation of content complexity.
 * @property timecodeInsertion Determines how timecodes should be inserted into the video elementary stream.
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsH264Settings(
    public val adaptiveQuantization: String? = null,
    public val afdSignaling: String? = null,
    public val bitrate: Int? = null,
    public val bufFillPct: Int? = null,
    public val bufSize: Int? = null,
    public val colorMetadata: String? = null,
    public val entropyEncoding: String? = null,
    public val filterSettings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettings? = null,
    public val fixedAfd: String? = null,
    public val flickerAq: String? = null,
    public val forceFieldPictures: String? = null,
    public val framerateControl: String? = null,
    public val framerateDenominator: Int? = null,
    public val framerateNumerator: Int? = null,
    public val gopBReference: String? = null,
    public val gopClosedCadence: Int? = null,
    public val gopNumBFrames: Int? = null,
    public val gopSize: Double? = null,
    public val gopSizeUnits: String? = null,
    public val level: String? = null,
    public val lookAheadRateControl: String? = null,
    public val maxBitrate: Int? = null,
    public val minIInterval: Int? = null,
    public val numRefFrames: Int? = null,
    public val parControl: String? = null,
    public val parDenominator: Int? = null,
    public val parNumerator: Int? = null,
    public val profile: String? = null,
    public val qualityLevel: String? = null,
    public val qvbrQualityLevel: Int? = null,
    public val rateControlMode: String? = null,
    public val scanType: String? = null,
    public val sceneChangeDetect: String? = null,
    public val slices: Int? = null,
    public val softness: Int? = null,
    public val spatialAq: String? = null,
    public val subgopLength: String? = null,
    public val syntax: String? = null,
    public val temporalAq: String? = null,
    public val timecodeInsertion: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264Settings): ChannelEncoderSettingsVideoDescriptionCodecSettingsH264Settings =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH264Settings(
                adaptiveQuantization = javaType.adaptiveQuantization().map({ args0 -> args0 }).orElse(null),
                afdSignaling = javaType.afdSignaling().map({ args0 -> args0 }).orElse(null),
                bitrate = javaType.bitrate().map({ args0 -> args0 }).orElse(null),
                bufFillPct = javaType.bufFillPct().map({ args0 -> args0 }).orElse(null),
                bufSize = javaType.bufSize().map({ args0 -> args0 }).orElse(null),
                colorMetadata = javaType.colorMetadata().map({ args0 -> args0 }).orElse(null),
                entropyEncoding = javaType.entropyEncoding().map({ args0 -> args0 }).orElse(null),
                filterSettings = javaType.filterSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH264SettingsFilterSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                fixedAfd = javaType.fixedAfd().map({ args0 -> args0 }).orElse(null),
                flickerAq = javaType.flickerAq().map({ args0 -> args0 }).orElse(null),
                forceFieldPictures = javaType.forceFieldPictures().map({ args0 -> args0 }).orElse(null),
                framerateControl = javaType.framerateControl().map({ args0 -> args0 }).orElse(null),
                framerateDenominator = javaType.framerateDenominator().map({ args0 -> args0 }).orElse(null),
                framerateNumerator = javaType.framerateNumerator().map({ args0 -> args0 }).orElse(null),
                gopBReference = javaType.gopBReference().map({ args0 -> args0 }).orElse(null),
                gopClosedCadence = javaType.gopClosedCadence().map({ args0 -> args0 }).orElse(null),
                gopNumBFrames = javaType.gopNumBFrames().map({ args0 -> args0 }).orElse(null),
                gopSize = javaType.gopSize().map({ args0 -> args0 }).orElse(null),
                gopSizeUnits = javaType.gopSizeUnits().map({ args0 -> args0 }).orElse(null),
                level = javaType.level().map({ args0 -> args0 }).orElse(null),
                lookAheadRateControl = javaType.lookAheadRateControl().map({ args0 -> args0 }).orElse(null),
                maxBitrate = javaType.maxBitrate().map({ args0 -> args0 }).orElse(null),
                minIInterval = javaType.minIInterval().map({ args0 -> args0 }).orElse(null),
                numRefFrames = javaType.numRefFrames().map({ args0 -> args0 }).orElse(null),
                parControl = javaType.parControl().map({ args0 -> args0 }).orElse(null),
                parDenominator = javaType.parDenominator().map({ args0 -> args0 }).orElse(null),
                parNumerator = javaType.parNumerator().map({ args0 -> args0 }).orElse(null),
                profile = javaType.profile().map({ args0 -> args0 }).orElse(null),
                qualityLevel = javaType.qualityLevel().map({ args0 -> args0 }).orElse(null),
                qvbrQualityLevel = javaType.qvbrQualityLevel().map({ args0 -> args0 }).orElse(null),
                rateControlMode = javaType.rateControlMode().map({ args0 -> args0 }).orElse(null),
                scanType = javaType.scanType().map({ args0 -> args0 }).orElse(null),
                sceneChangeDetect = javaType.sceneChangeDetect().map({ args0 -> args0 }).orElse(null),
                slices = javaType.slices().map({ args0 -> args0 }).orElse(null),
                softness = javaType.softness().map({ args0 -> args0 }).orElse(null),
                spatialAq = javaType.spatialAq().map({ args0 -> args0 }).orElse(null),
                subgopLength = javaType.subgopLength().map({ args0 -> args0 }).orElse(null),
                syntax = javaType.syntax().map({ args0 -> args0 }).orElse(null),
                temporalAq = javaType.temporalAq().map({ args0 -> args0 }).orElse(null),
                timecodeInsertion = javaType.timecodeInsertion().map({ args0 -> args0 }).orElse(null),
            )
    }
}
