@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property colorSpacePassthroughSettings Sets the colorspace metadata to be passed through.
 * @property dolbyVision81Settings Set the colorspace to Dolby Vision81.
 * @property hdr10Settings Set the colorspace to be HDR10. See H265 HDR10 Settings for more details.
 * @property rec601Settings Set the colorspace to Rec. 601.
 * @property rec709Settings Set the colorspace to Rec. 709.
 */
public data class ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettings(
    public val colorSpacePassthroughSettings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettings? =
        null,
    public val dolbyVision81Settings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81Settings? =
        null,
    public val hdr10Settings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10Settings? =
        null,
    public val rec601Settings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601Settings? =
        null,
    public val rec709Settings: ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709Settings? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettings): ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettings =
            ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettings(
                colorSpacePassthroughSettings = javaType.colorSpacePassthroughSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsColorSpacePassthroughSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dolbyVision81Settings = javaType.dolbyVision81Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsDolbyVision81Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                hdr10Settings = javaType.hdr10Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsHdr10Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rec601Settings = javaType.rec601Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec601Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                rec709Settings = javaType.rec709Settings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettingsVideoDescriptionCodecSettingsH265SettingsColorSpaceSettingsRec709Settings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
