@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property automaticInputFailoverSettings User-specified settings for defining what the conditions are for declaring the input unhealthy and failing over to a different input. See Automatic Input Failover Settings for more details.
 * @property inputAttachmentName User-specified name for the attachment.
 * @property inputId The ID of the input.
 * @property inputSettings Settings of an input. See Input Settings for more details.
 */
public data class ChannelInputAttachment(
    public val automaticInputFailoverSettings: ChannelInputAttachmentAutomaticInputFailoverSettings? =
        null,
    public val inputAttachmentName: String,
    public val inputId: String,
    public val inputSettings: ChannelInputAttachmentInputSettings? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachment): ChannelInputAttachment = ChannelInputAttachment(
            automaticInputFailoverSettings = javaType.automaticInputFailoverSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentAutomaticInputFailoverSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
            inputAttachmentName = javaType.inputAttachmentName(),
            inputId = javaType.inputId(),
            inputSettings = javaType.inputSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettings.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
