@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dolbyEDecode Configure decoding options for Dolby E streams - these should be Dolby E frames carried in PCM streams tagged with SMPTE-337. See Dolby E Decode for more details.
 * @property tracks Selects one or more unique audio tracks from within a source. See Audio Tracks for more details.
 */
public data class
ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelection(
    public val dolbyEDecode: ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecode? =
        null,
    public val tracks: List<ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrack>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelection): ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelection =
            ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelection(
                dolbyEDecode = javaType.dolbyEDecode().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionDolbyEDecode.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                tracks = javaType.tracks().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsAudioSelectorSelectorSettingsAudioTrackSelectionTrack.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
