@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property ancillarySourceSettings Ancillary Source Settings. See Ancillary Source Settings for more details.
 * @property aribSourceSettings ARIB Source Settings.
 * @property dvbSubSourceSettings DVB Sub Source Settings. See DVB Sub Source Settings for more details.
 * @property embeddedSourceSettings Embedded Source Settings. See Embedded Source Settings for more details.
 * @property scte20SourceSettings SCTE20 Source Settings. See SCTE 20 Source Settings for more details.
 * @property scte27SourceSettings SCTE27 Source Settings. See SCTE 27 Source Settings for more details.
 * @property teletextSourceSettings Teletext Source Settings. See Teletext Source Settings for more details.
 */
public data class ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettings(
    public val ancillarySourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettings? =
        null,
    public val aribSourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettings? = null,
    public val dvbSubSourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettings? =
        null,
    public val embeddedSourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettings? =
        null,
    public val scte20SourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings? =
        null,
    public val scte27SourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettings? =
        null,
    public val teletextSourceSettings: ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettings? =
        null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettings): ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettings =
            ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettings(
                ancillarySourceSettings = javaType.ancillarySourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAncillarySourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                aribSourceSettings = javaType.aribSourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsAribSourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                dvbSubSourceSettings = javaType.dvbSubSourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsDvbSubSourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                embeddedSourceSettings = javaType.embeddedSourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsEmbeddedSourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scte20SourceSettings = javaType.scte20SourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte20SourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                scte27SourceSettings = javaType.scte27SourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsScte27SourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                teletextSourceSettings = javaType.teletextSourceSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsCaptionSelectorSelectorSettingsTeletextSourceSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
            )
    }
}
