@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hlsInputSettings Specifies HLS input settings when the uri is for a HLS manifest. See HLS Input Settings for more details.
 * @property serverValidation Check HTTPS server certificates.
 */
public data class ChannelInputAttachmentInputSettingsNetworkInputSettings(
    public val hlsInputSettings: ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings? = null,
    public val serverValidation: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsNetworkInputSettings): ChannelInputAttachmentInputSettingsNetworkInputSettings =
            ChannelInputAttachmentInputSettingsNetworkInputSettings(
                hlsInputSettings = javaType.hlsInputSettings().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                serverValidation = javaType.serverValidation().map({ args0 -> args0 }).orElse(null),
            )
    }
}
