@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property bandwidth The bitrate is specified in bits per second, as in an HLS manifest.
 * @property bufferSegments Buffer segments.
 * @property retries The number of consecutive times that attempts to read a manifest or segment must fail before the input is considered unavailable.
 * @property retryInterval The number of seconds between retries when an attempt to read a manifest or segment fails.
 * @property scte35Source
 */
public data class ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings(
    public val bandwidth: Int? = null,
    public val bufferSegments: Int? = null,
    public val retries: Int? = null,
    public val retryInterval: Int? = null,
    public val scte35Source: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings): ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings =
            ChannelInputAttachmentInputSettingsNetworkInputSettingsHlsInputSettings(
                bandwidth = javaType.bandwidth().map({ args0 -> args0 }).orElse(null),
                bufferSegments = javaType.bufferSegments().map({ args0 -> args0 }).orElse(null),
                retries = javaType.retries().map({ args0 -> args0 }).orElse(null),
                retryInterval = javaType.retryInterval().map({ args0 -> args0 }).orElse(null),
                scte35Source = javaType.scte35Source().map({ args0 -> args0 }).orElse(null),
            )
    }
}
