@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property maintenanceDay The day of the week to use for maintenance.
 * @property maintenanceStartTime The hour maintenance will start.
 */
public data class ChannelMaintenance(
    public val maintenanceDay: String,
    public val maintenanceStartTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.ChannelMaintenance): ChannelMaintenance = ChannelMaintenance(
            maintenanceDay = javaType.maintenanceDay(),
            maintenanceStartTime = javaType.maintenanceStartTime(),
        )
    }
}
