@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property ip
 * @property port
 * @property url
 * @property vpcs
 */
public data class GetInputDestination(
    public val ip: String,
    public val port: String,
    public val url: String,
    public val vpcs: List<GetInputDestinationVpc>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.GetInputDestination): GetInputDestination = GetInputDestination(
            ip = javaType.ip(),
            port = javaType.port(),
            url = javaType.url(),
            vpcs = javaType.vpcs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.medialive.kotlin.outputs.GetInputDestinationVpc.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
