@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getInput.
 * @property arn ARN of the Input.
 * @property attachedChannels Channels attached to Input.
 * @property destinations
 * @property id
 * @property inputClass The input class.
 * @property inputDevices Settings for the devices.
 * @property inputPartnerIds A list of IDs for all Inputs which are partners of this one.
 * @property inputSourceType Source type of the input.
 * @property mediaConnectFlows A list of the MediaConnect Flows.
 * @property name Name of the input.
 * @property roleArn The ARN of the role this input assumes during and after creation.
 * @property securityGroups List of input security groups.
 * @property sources The source URLs for a PULL-type input.
 * @property state The state of the input.
 * @property tags A map of tags assigned to the Input.
 * @property type The type of the input.
 */
public data class GetInputResult(
    public val arn: String,
    public val attachedChannels: List<String>,
    public val destinations: List<GetInputDestination>,
    public val id: String,
    public val inputClass: String,
    public val inputDevices: List<GetInputInputDevice>,
    public val inputPartnerIds: List<String>,
    public val inputSourceType: String,
    public val mediaConnectFlows: List<GetInputMediaConnectFlow>,
    public val name: String,
    public val roleArn: String,
    public val securityGroups: List<String>,
    public val sources: List<GetInputSource>,
    public val state: String,
    public val tags: Map<String, String>,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.GetInputResult): GetInputResult =
            GetInputResult(
                arn = javaType.arn(),
                attachedChannels = javaType.attachedChannels().map({ args0 -> args0 }),
                destinations = javaType.destinations().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.GetInputDestination.Companion.toKotlin(args0)
                    })
                }),
                id = javaType.id(),
                inputClass = javaType.inputClass(),
                inputDevices = javaType.inputDevices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.GetInputInputDevice.Companion.toKotlin(args0)
                    })
                }),
                inputPartnerIds = javaType.inputPartnerIds().map({ args0 -> args0 }),
                inputSourceType = javaType.inputSourceType(),
                mediaConnectFlows = javaType.mediaConnectFlows().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.GetInputMediaConnectFlow.Companion.toKotlin(args0)
                    })
                }),
                name = javaType.name(),
                roleArn = javaType.roleArn(),
                securityGroups = javaType.securityGroups().map({ args0 -> args0 }),
                sources = javaType.sources().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.medialive.kotlin.outputs.GetInputSource.Companion.toKotlin(args0)
                    })
                }),
                state = javaType.state(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
                type = javaType.type(),
            )
    }
}
