@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property securityGroupIds A list of up to 5 EC2 VPC security group IDs to attach to the Input.
 * @property subnetIds A list of 2 VPC subnet IDs from the same VPC.
 */
public data class InputVpc(
    public val securityGroupIds: List<String>? = null,
    public val subnetIds: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.medialive.outputs.InputVpc): InputVpc = InputVpc(
            securityGroupIds = javaType.securityGroupIds().map({ args0 -> args0 }),
            subnetIds = javaType.subnetIds().map({ args0 -> args0 }),
        )
    }
}
