@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediapackage.kotlin

import com.pulumi.aws.mediapackage.kotlin.outputs.ChannelHlsIngest
import com.pulumi.aws.mediapackage.kotlin.outputs.ChannelHlsIngest.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.aws.mediapackage.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * Provides an AWS Elemental MediaPackage Channel.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const kittens = new aws.mediapackage.Channel("kittens", {
 *     channelId: "kitten-channel",
 *     description: "A channel dedicated to amusing videos of kittens.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * kittens = aws.mediapackage.Channel("kittens",
 *     channel_id="kitten-channel",
 *     description="A channel dedicated to amusing videos of kittens.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kittens = new Aws.MediaPackage.Channel("kittens", new()
 *     {
 *         ChannelId = "kitten-channel",
 *         Description = "A channel dedicated to amusing videos of kittens.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mediapackage"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mediapackage.NewChannel(ctx, "kittens", &mediapackage.ChannelArgs{
 * 			ChannelId:   pulumi.String("kitten-channel"),
 * 			Description: pulumi.String("A channel dedicated to amusing videos of kittens."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mediapackage.Channel;
 * import com.pulumi.aws.mediapackage.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kittens = new Channel("kittens", ChannelArgs.builder()
 *             .channelId("kitten-channel")
 *             .description("A channel dedicated to amusing videos of kittens.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   kittens:
 *     type: aws:mediapackage:Channel
 *     properties:
 *       channelId: kitten-channel
 *       description: A channel dedicated to amusing videos of kittens.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Media Package Channels using the channel ID. For example:
 * ```sh
 * $ pulumi import aws:mediapackage/channel:Channel kittens kittens-channel
 * ```
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.aws.mediapackage.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * The ARN of the channel
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A unique identifier describing the channel
     */
    public val channelId: Output<String>
        get() = javaResource.channelId().applyValue({ args0 -> args0 })

    /**
     * A description of the channel
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * A single item list of HLS ingest information
     */
    public val hlsIngests: Output<List<ChannelHlsIngest>>
        get() = javaResource.hlsIngests().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mediapackage.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.aws.mediapackage.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
