@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediapackage.kotlin

import com.pulumi.aws.mediapackage.ChannelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Elemental MediaPackage Channel.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const kittens = new aws.mediapackage.Channel("kittens", {
 *     channelId: "kitten-channel",
 *     description: "A channel dedicated to amusing videos of kittens.",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * kittens = aws.mediapackage.Channel("kittens",
 *     channel_id="kitten-channel",
 *     description="A channel dedicated to amusing videos of kittens.")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var kittens = new Aws.MediaPackage.Channel("kittens", new()
 *     {
 *         ChannelId = "kitten-channel",
 *         Description = "A channel dedicated to amusing videos of kittens.",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mediapackage"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mediapackage.NewChannel(ctx, "kittens", &mediapackage.ChannelArgs{
 * 			ChannelId:   pulumi.String("kitten-channel"),
 * 			Description: pulumi.String("A channel dedicated to amusing videos of kittens."),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mediapackage.Channel;
 * import com.pulumi.aws.mediapackage.ChannelArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var kittens = new Channel("kittens", ChannelArgs.builder()
 *             .channelId("kitten-channel")
 *             .description("A channel dedicated to amusing videos of kittens.")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   kittens:
 *     type: aws:mediapackage:Channel
 *     properties:
 *       channelId: kitten-channel
 *       description: A channel dedicated to amusing videos of kittens.
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import Media Package Channels using the channel ID. For example:
 * ```sh
 * $ pulumi import aws:mediapackage/channel:Channel kittens kittens-channel
 * ```
 * @property channelId A unique identifier describing the channel
 * @property description A description of the channel
 * @property tags A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ChannelArgs(
    public val channelId: Output<String>? = null,
    public val description: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.mediapackage.ChannelArgs> {
    override fun toJava(): com.pulumi.aws.mediapackage.ChannelArgs =
        com.pulumi.aws.mediapackage.ChannelArgs.builder()
            .channelId(channelId?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var channelId: Output<String>? = null

    private var description: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A unique identifier describing the channel
     */
    @JvmName("hwcuoapisxewuqsr")
    public suspend fun channelId(`value`: Output<String>) {
        this.channelId = value
    }

    /**
     * @param value A description of the channel
     */
    @JvmName("ecephjpwvjabybnh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("neftfpypsvvkuegg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A unique identifier describing the channel
     */
    @JvmName("aeovcaatwraduqjq")
    public suspend fun channelId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelId = mapped
    }

    /**
     * @param value A description of the channel
     */
    @JvmName("yftedqwyxaixltnf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("lcciainhmunsitnd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ffbeegqqkjuglnst")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        channelId = channelId,
        description = description,
        tags = tags,
    )
}
