@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediastore.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Container].
 */
@PulumiTagMarker
public class ContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ContainerArgs = ContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ContainerArgsBuilder.() -> Unit) {
        val builder = ContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Container {
        val builtJavaResource = com.pulumi.aws.mediastore.Container(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Container(builtJavaResource)
    }
}

/**
 * Provides a MediaStore Container.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.mediastore.Container("example", {name: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.mediastore.Container("example", name="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MediaStore.Container("example", new()
 *     {
 *         Name = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/mediastore"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := mediastore.NewContainer(ctx, "example", &mediastore.ContainerArgs{
 * 			Name: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mediastore.Container;
 * import com.pulumi.aws.mediastore.ContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Container("example", ContainerArgs.builder()
 *             .name("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:mediastore:Container
 *     properties:
 *       name: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import MediaStore Container using the MediaStore Container Name. For example:
 * ```sh
 * $ pulumi import aws:mediastore/container:Container example example
 * ```
 */
public class Container internal constructor(
    override val javaResource: com.pulumi.aws.mediastore.Container,
) : KotlinCustomResource(javaResource, ContainerMapper) {
    /**
     * The ARN of the container.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The DNS endpoint of the container.
     */
    public val endpoint: Output<String>
        get() = javaResource.endpoint().applyValue({ args0 -> args0 })

    /**
     * The name of the container. Must contain alphanumeric characters or underscores.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ContainerMapper : ResourceMapper<Container> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mediastore.Container::class == javaResource::class

    override fun map(javaResource: Resource): Container = Container(
        javaResource as
            com.pulumi.aws.mediastore.Container,
    )
}

/**
 * @see [Container].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Container].
 */
public suspend fun container(name: String, block: suspend ContainerResourceBuilder.() -> Unit): Container {
    val builder = ContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Container].
 * @param name The _unique_ name of the resulting resource.
 */
public fun container(name: String): Container {
    val builder = ContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
