@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.memorydb.kotlin

import com.pulumi.aws.memorydb.AclArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a MemoryDB ACL.
 * More information about users and ACL-s can be found in the [MemoryDB User Guide](https://docs.aws.amazon.com/memorydb/latest/devguide/clusters.acls.html).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.memorydb.Acl("example", {
 *     name: "my-acl",
 *     userNames: [
 *         "my-user-1",
 *         "my-user-2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.memorydb.Acl("example",
 *     name="my-acl",
 *     user_names=[
 *         "my-user-1",
 *         "my-user-2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.MemoryDb.Acl("example", new()
 *     {
 *         Name = "my-acl",
 *         UserNames = new[]
 *         {
 *             "my-user-1",
 *             "my-user-2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/memorydb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := memorydb.NewAcl(ctx, "example", &memorydb.AclArgs{
 * 			Name: pulumi.String("my-acl"),
 * 			UserNames: pulumi.StringArray{
 * 				pulumi.String("my-user-1"),
 * 				pulumi.String("my-user-2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.memorydb.Acl;
 * import com.pulumi.aws.memorydb.AclArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Acl("example", AclArgs.builder()
 *             .name("my-acl")
 *             .userNames(
 *                 "my-user-1",
 *                 "my-user-2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:memorydb:Acl
 *     properties:
 *       name: my-acl
 *       userNames:
 *         - my-user-1
 *         - my-user-2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import an ACL using the `name`. For example:
 * ```sh
 * $ pulumi import aws:memorydb/acl:Acl example my-acl
 * ```
 * @property name Name of the ACL. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property tags A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userNames Set of MemoryDB user names to be included in this ACL.
 */
public data class AclArgs(
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userNames: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.memorydb.AclArgs> {
    override fun toJava(): com.pulumi.aws.memorydb.AclArgs = com.pulumi.aws.memorydb.AclArgs.builder()
        .name(name?.applyValue({ args0 -> args0 }))
        .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
        .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
        .userNames(userNames?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [AclArgs].
 */
@PulumiTagMarker
public class AclArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userNames: Output<List<String>>? = null

    /**
     * @param value Name of the ACL. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("isgixnifompfytwo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("uukedwgtsjeownjw")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wbboweekugchbves")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Set of MemoryDB user names to be included in this ACL.
     */
    @JvmName("oiptsnmameumsxxu")
    public suspend fun userNames(`value`: Output<List<String>>) {
        this.userNames = value
    }

    @JvmName("jtygublmsidaqgdn")
    public suspend fun userNames(vararg values: Output<String>) {
        this.userNames = Output.all(values.asList())
    }

    /**
     * @param values Set of MemoryDB user names to be included in this ACL.
     */
    @JvmName("axbxddyoerherpnk")
    public suspend fun userNames(values: List<Output<String>>) {
        this.userNames = Output.all(values)
    }

    /**
     * @param value Name of the ACL. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("ierkmpohjcfoncgy")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("nwhklecnxggnfudq")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("omootehkjildfvar")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the resource. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pjyetdsldrksoqfv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Set of MemoryDB user names to be included in this ACL.
     */
    @JvmName("tkujqeahrpxnkevm")
    public suspend fun userNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userNames = mapped
    }

    /**
     * @param values Set of MemoryDB user names to be included in this ACL.
     */
    @JvmName("dtqfioksgqewcags")
    public suspend fun userNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userNames = mapped
    }

    internal fun build(): AclArgs = AclArgs(
        name = name,
        namePrefix = namePrefix,
        tags = tags,
        userNames = userNames,
    )
}
